/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.type;

import com.nomiceu.gregtechdrawers.type.FilterableIterable;
import com.nomiceu.gregtechdrawers.type.StreamableIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface StreamableFilterableIterable<T>
extends StreamableIterable<T>,
FilterableIterable<T> {
    @Override
    default public StreamableFilterableIterable<T> filter(Predicate<? super T> filter) {
        return () -> StreamSupport.stream(this.spliterator(), false).filter(filter).iterator();
    }

    @Override
    default public <E extends T> StreamableFilterableIterable<E> filter(Class<E> type) {
        return () -> StreamSupport.stream(this.spliterator(), false).filter(type::isInstance).map(type::cast).iterator();
    }

    public static <T> StreamableFilterableIterable<T> wrap(Iterable<T> iter) {
        return iter instanceof StreamableFilterableIterable ? (StreamableFilterableIterable)iter : iter::iterator;
    }

    public static <T> StreamableFilterableIterable<T> wrap(final Collection<T> c) {
        return new StreamableFilterableIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return c.iterator();
            }

            @Override
            public Stream<T> stream() {
                return c.stream();
            }

            @Override
            public Stream<T> parallelStream() {
                return c.parallelStream();
            }
        };
    }
}

