/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.gregtechdrawers.type;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface StreamableIterable<T>
extends Iterable<T> {
    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public static <T> StreamableIterable<T> wrap(Iterable<T> iterable) {
        return iterable instanceof StreamableIterable ? (StreamableIterable)iterable : iterable::iterator;
    }

    public static <T> StreamableIterable<T> wrap(final Collection<T> c) {
        return new StreamableIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return c.iterator();
            }

            @Override
            public Stream<T> stream() {
                return c.stream();
            }

            @Override
            public Stream<T> parallelStream() {
                return c.parallelStream();
            }
        };
    }
}

