/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.util;

import info.loenwind.autosave.util.NullHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Supplier;

public class TypeUtil {
    public static Class<?> toClass(Type type) {
        return (Class)(type instanceof ParameterizedType ? NullHelper.notnullJ(((ParameterizedType)type).getRawType(), "ParameterizedType#getRawType") : type);
    }

    public static boolean isAssignable(Class<?> clazz, Type type) {
        return clazz.isAssignableFrom(TypeUtil.toClass(type));
    }

    public static <T> Supplier<T> defaultConstructorFactory(Class<T> clazz) {
        MethodHandle handle;
        try {
            handle = MethodHandles.lookup().unreflectConstructor(clazz.getConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return () -> {
            try {
                return handle.invoke();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Type getGenericType(Field field) {
        return NullHelper.notnullJ(field.getGenericType(), "Field#getGenericType");
    }
}

