/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.layout;

import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import java.util.function.Predicate;

public interface IViewport {
    public static final IViewport EMPTY = (viewports, widgets, x, y) -> {};

    default public void transformChildren(IViewportStack stack) {
    }

    public void getWidgetsAt(IViewportStack var1, HoveredWidgetList var2, int var3, int var4);

    default public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
    }

    default public void preDraw(GuiContext context, boolean transformed) {
    }

    default public void postDraw(GuiContext context, boolean transformed) {
    }

    public static void getChildrenAt(IWidget parent, IViewportStack stack, HoveredWidgetList widgetList, int x, int y) {
        for (IWidget child : parent.getChildren()) {
            if (!child.isEnabled()) continue;
            if (child instanceof IViewport) {
                IViewport viewport = (IViewport)((Object)child);
                stack.pushViewport(viewport, parent.getArea());
                child.transform(stack);
                viewport.getSelfAt(stack, widgetList, x, y);
                viewport.transformChildren(stack);
                viewport.getWidgetsAt(stack, widgetList, x, y);
                stack.popViewport(viewport);
                continue;
            }
            stack.pushMatrix();
            child.transform(stack);
            if (child.isInside(stack, x, y)) {
                widgetList.add(child, stack.peek());
            }
            if (child.hasChildren()) {
                IViewport.getChildrenAt(child, stack, widgetList, x, y);
            }
            stack.popMatrix();
        }
    }

    public static boolean foreachChild(IViewportStack stack, IWidget parent, Predicate<IWidget> predicate, int context) {
        for (IWidget child : parent.getChildren()) {
            if (!child.isEnabled()) continue;
            stack.popMatrix();
            if (child instanceof IViewport) {
                IViewport viewport = (IViewport)((Object)child);
                stack.pushViewport(viewport, parent.getArea());
                parent.transform(stack);
                if (!predicate.test(child)) {
                    stack.popViewport(viewport);
                    return false;
                }
                viewport.transformChildren(parent.getContext());
                if (child.hasChildren() && !IViewport.foreachChild(stack, child, predicate, context)) {
                    stack.popViewport(viewport);
                    return false;
                }
                stack.popViewport(viewport);
                continue;
            }
            stack.pushMatrix();
            parent.transform(stack);
            if (!predicate.test(child)) {
                stack.popMatrix();
                return false;
            }
            if (child.hasChildren() && !IViewport.foreachChild(stack, child, predicate, context)) {
                stack.popMatrix();
                return false;
            }
            stack.popMatrix();
        }
        return true;
    }
}

