/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.bogosorter.api.IPosSetter;
import com.cleanroommc.bogosorter.api.ISortableContainer;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.core.mixin.ContainerAccessor;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(modid="bogosorter", iface="com.cleanroommc.bogosorter.api.ISortableContainer")
public class ModularContainer
extends Container
implements ISortableContainer {
    private final GuiSyncManager guiSyncManager;
    private boolean init = true;
    private boolean handshake = false;
    private final List<ModularSlot> slots = new ArrayList<ModularSlot>();
    private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();
    private static final int DROP_TO_WORLD = -999;
    private static final int LEFT_MOUSE = 0;
    private static final int RIGHT_MOUSE = 1;

    public static ModularContainer getCurrent(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ModularContainer) {
            ModularContainer container2 = (ModularContainer)container;
            return container2;
        }
        return null;
    }

    public ModularContainer(GuiSyncManager guiSyncManager) {
        this.guiSyncManager = Objects.requireNonNull(guiSyncManager);
        this.guiSyncManager.construct(this);
        this.sortShiftClickSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public ModularContainer() {
        this.guiSyncManager = null;
    }

    public ContainerAccessor acc() {
        return (ContainerAccessor)((Object)this);
    }

    public void func_75134_a(@NotNull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.handshake = false;
        if (this.guiSyncManager != null) {
            this.guiSyncManager.onClose();
        }
    }

    public void func_75142_b() {
        if (this.handshake) {
            super.func_75142_b();
        }
        this.guiSyncManager.detectAndSendChanges(this.init);
        this.init = false;
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(Comparator.comparingInt(slot -> Objects.requireNonNull(slot.getSlotGroup()).getShiftClickPriority()));
    }

    public void func_190896_a(@NotNull List<ItemStack> items) {
        if (this.field_75151_b.size() != items.size()) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", (Object)this.field_75151_b.size(), (Object)items.size());
        }
        for (int i = 0; i < Math.min(this.field_75151_b.size(), items.size()); ++i) {
            this.func_75139_a(i).func_75215_d(items.get(i));
        }
    }

    @ApiStatus.Internal
    public void registerSlot(ModularSlot slot) {
        SlotGroup slotGroup;
        if (this.field_75151_b.contains((Object)slot)) {
            throw new IllegalArgumentException("Tried to register slot which already exists!");
        }
        this.func_75146_a((Slot)slot);
        this.slots.add(slot);
        if (slot.getSlotGroupName() != null) {
            slotGroup = this.getSyncManager().getSlotGroup(slot.getSlotGroupName());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + slot.getSlotGroupName() + "' is not registered!"));
                return;
            }
            slot.slotGroup(slotGroup);
        }
        if (slot.getSlotGroup() != null && (slotGroup = slot.getSlotGroup()).allowShiftTransfer()) {
            this.shiftClickSlots.add(slot);
            if (!this.init) {
                this.sortShiftClickSlots();
            }
        }
    }

    @Contract(value="null, null -> fail")
    @NotNull
    @ApiStatus.Internal
    public SlotGroup validateSlotGroup(@Nullable String slotGroupName, @Nullable SlotGroup slotGroup) {
        if (slotGroup != null) {
            if (this.getSyncManager().getSlotGroup(slotGroup.getName()) == null) {
                throw new IllegalArgumentException("Slot group is not registered in the GUI.");
            }
            return slotGroup;
        }
        if (slotGroupName != null) {
            slotGroup = this.getSyncManager().getSlotGroup(slotGroupName);
            if (slotGroup == null) {
                throw new IllegalArgumentException("Can't find slot group for name " + slotGroupName);
            }
            return slotGroup;
        }
        throw new IllegalArgumentException("Either the slot group or the name must not be null!");
    }

    public GuiSyncManager getSyncManager() {
        if (this.guiSyncManager == null) {
            throw new IllegalStateException("GuiSyncManager is not available for client only GUI's.");
        }
        return this.guiSyncManager;
    }

    public boolean isClient() {
        return this.guiSyncManager == null || NetworkUtils.isClient(this.guiSyncManager.getPlayer());
    }

    public boolean isClientOnly() {
        return this.guiSyncManager == null;
    }

    public boolean func_75145_c(@NotNull EntityPlayer playerIn) {
        return true;
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int mouseButton, @NotNull ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnable = ItemStack.field_190927_a;
        InventoryPlayer inventoryplayer = player.field_71071_by;
        if (clickTypeIn == ClickType.QUICK_CRAFT || this.acc().getDragEvent() != 0) {
            return super.func_184996_a(slotId, mouseButton, clickTypeIn, player);
        }
        if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                if (!inventoryplayer.func_70445_o().func_190926_b()) {
                    if (mouseButton == 0) {
                        player.func_71019_a(inventoryplayer.func_70445_o(), true);
                        inventoryplayer.func_70437_b(ItemStack.field_190927_a);
                    }
                    if (mouseButton == 1) {
                        player.func_71019_a(inventoryplayer.func_70445_o().func_77979_a(1), true);
                    }
                }
                return inventoryplayer.func_70445_o();
            }
            if (clickTypeIn == ClickType.QUICK_MOVE) {
                Slot fromSlot = this.func_75139_a(slotId);
                if (!fromSlot.func_82869_a(player)) {
                    return ItemStack.field_190927_a;
                }
                returnable = this.func_82846_b(player, slotId);
            } else {
                Slot clickedSlot = this.func_75139_a(slotId);
                ItemStack slotStack = clickedSlot.func_75211_c();
                ItemStack heldStack = inventoryplayer.func_70445_o();
                if (slotStack.func_190926_b()) {
                    if (!heldStack.func_190926_b() && clickedSlot.func_75214_a(heldStack)) {
                        int stackCount;
                        int n = stackCount = mouseButton == 0 ? heldStack.func_190916_E() : 1;
                        if (stackCount > clickedSlot.func_178170_b(heldStack)) {
                            stackCount = clickedSlot.func_178170_b(heldStack);
                        }
                        clickedSlot.func_75215_d(heldStack.func_77979_a(stackCount));
                    }
                } else if (clickedSlot.func_82869_a(player)) {
                    int stackCount;
                    if (heldStack.func_190926_b() && !slotStack.func_190926_b()) {
                        int toRemove = mouseButton == 0 ? slotStack.func_190916_E() : (slotStack.func_190916_E() + 1) / 2;
                        inventoryplayer.func_70437_b(slotStack.func_77979_a(toRemove));
                        clickedSlot.func_75215_d(slotStack);
                        clickedSlot.func_190901_a(player, inventoryplayer.func_70445_o());
                    } else if (clickedSlot.func_75214_a(heldStack)) {
                        if (slotStack.func_77973_b() == heldStack.func_77973_b() && slotStack.func_77960_j() == heldStack.func_77960_j() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack)) {
                            int stackCount2;
                            int n = stackCount2 = mouseButton == 0 ? heldStack.func_190916_E() : 1;
                            if (stackCount2 > clickedSlot.func_178170_b(heldStack) - slotStack.func_190916_E()) {
                                stackCount2 = clickedSlot.func_178170_b(heldStack) - slotStack.func_190916_E();
                            }
                            if (stackCount2 > heldStack.func_77976_d() - slotStack.func_190916_E()) {
                                stackCount2 = heldStack.func_77976_d() - slotStack.func_190916_E();
                            }
                            heldStack.func_190918_g(stackCount2);
                            slotStack.func_190917_f(stackCount2);
                            clickedSlot.func_75215_d(slotStack);
                        } else if (heldStack.func_190916_E() <= clickedSlot.func_178170_b(heldStack)) {
                            clickedSlot.func_75215_d(heldStack);
                            inventoryplayer.func_70437_b(slotStack);
                        }
                    } else if (!(slotStack.func_77973_b() != heldStack.func_77973_b() || heldStack.func_77976_d() <= 1 || slotStack.func_77981_g() && slotStack.func_77960_j() != heldStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack) || slotStack.func_190926_b() || (stackCount = slotStack.func_190916_E()) + heldStack.func_190916_E() > heldStack.func_77976_d())) {
                        heldStack.func_190917_f(stackCount);
                        slotStack = clickedSlot.func_75209_a(stackCount);
                        if (slotStack.func_190926_b()) {
                            clickedSlot.func_75215_d(ItemStack.field_190927_a);
                        }
                        clickedSlot.func_190901_a(player, inventoryplayer.func_70445_o());
                    }
                }
                clickedSlot.func_75218_e();
            }
            this.func_75142_b();
            return returnable;
        }
        return super.func_184996_a(slotId, mouseButton, clickTypeIn, player);
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull EntityPlayer playerIn, int index) {
        ItemStack stack;
        ModularSlot slot = this.slots.get(index);
        if (!slot.isPhantom() && !(stack = slot.func_75211_c()).func_190926_b()) {
            ItemStack remainder = this.transferItem(slot, stack.func_77946_l());
            if (remainder.func_190926_b()) {
                stack = ItemStack.field_190927_a;
            } else {
                stack.func_190920_e(remainder.func_190916_E());
            }
            slot.func_75215_d(stack);
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack transferItem(ModularSlot fromSlot, ItemStack fromStack) {
        @Nullable SlotGroup fromSlotGroup = fromSlot.getSlotGroup();
        for (ModularSlot toSlot : this.shiftClickSlots) {
            int maxSize;
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            ItemStack toStack = toSlot.func_75211_c().func_77946_l();
            if (toSlot.isPhantom()) {
                if (!toStack.func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)fromStack, (ItemStack)toStack) || toStack.func_190916_E() >= toSlot.func_178170_b(toStack))) continue;
                toSlot.func_75215_d(fromStack.func_77946_l());
                return fromStack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)fromStack, (ItemStack)toStack)) continue;
            int j = toStack.func_190916_E() + fromStack.func_190916_E();
            if (j <= (maxSize = Math.min(toSlot.func_75219_a(), fromStack.func_77976_d()))) {
                fromStack.func_190920_e(0);
                toStack.func_190920_e(j);
                toSlot.func_75215_d(toStack);
            } else if (toStack.func_190916_E() < maxSize) {
                fromStack.func_190918_g(maxSize - toStack.func_190916_E());
                toStack.func_190920_e(maxSize);
                toSlot.func_75215_d(toStack);
            }
            if (!fromStack.func_190926_b()) continue;
            return fromStack;
        }
        for (ModularSlot emptySlot : this.shiftClickSlots) {
            ItemStack itemstack = emptySlot.func_75211_c();
            SlotGroup slotGroup = Objects.requireNonNull(emptySlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !emptySlot.func_111238_b() || !itemstack.func_190926_b() || !emptySlot.func_75214_a(fromStack)) continue;
            if (fromStack.func_190916_E() > emptySlot.func_75219_a()) {
                emptySlot.func_75215_d(fromStack.func_77979_a(emptySlot.func_75219_a()));
            } else {
                emptySlot.func_75215_d(fromStack.func_77979_a(fromStack.func_190916_E()));
            }
            if (fromStack.func_190916_E() >= 1) continue;
            break;
        }
        return fromStack;
    }

    private static boolean isPlayerSlot(Slot slot) {
        SlotItemHandler slotItemHandler;
        IItemHandler iItemHandler;
        if (slot == null) {
            return false;
        }
        if (slot.field_75224_c instanceof InventoryPlayer) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        if (slot instanceof SlotItemHandler && ((iItemHandler = (slotItemHandler = (SlotItemHandler)slot).getItemHandler()) instanceof PlayerMainInvWrapper || iItemHandler instanceof PlayerInvWrapper)) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        return false;
    }

    public void buildSortingContext(ISortingContextBuilder builder) {
        for (SlotGroup slotGroup : this.getSyncManager().getSlotGroups()) {
            if (!slotGroup.isAllowSorting() || ModularContainer.isPlayerSlot(slotGroup.getSlots().get(0))) continue;
            builder.addSlotGroupOf(slotGroup.getSlots(), slotGroup.getRowSize()).buttonPosSetter(null).priority(slotGroup.getShiftClickPriority());
        }
    }

    public IPosSetter getPlayerButtonPosSetter() {
        return null;
    }

    public void onHandshake() {
        this.handshake = true;
    }
}

