/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.core.mixin.GuiContainerAccessor;
import com.cleanroommc.modularui.screen.DraggablePanelWrapper;
import com.cleanroommc.modularui.screen.JeiSettingsImpl;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.PanelManager;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedElement;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiContext
extends GuiViewportStack {
    public final Minecraft mc;
    public final FontRenderer font;
    public final ModularScreen screen;
    private LocatedWidget focusedWidget = LocatedWidget.EMPTY;
    @Nullable
    private IGuiElement hovered;
    private int timeHovered = 0;
    private final HoveredIterable hoveredWidgets;
    private LocatedElement<IDraggable> draggable;
    private int lastButton = -1;
    private long lastClickTime = 0L;
    private int lastDragX;
    private int lastDragY;
    private int mouseX;
    private int mouseY;
    private int mouseButton;
    private int mouseWheel;
    private char typedChar;
    private int keyCode;
    private float partialTicks;
    private long tick;
    public List<Consumer<GuiContext>> postRenderCallbacks = new ArrayList<Consumer<GuiContext>>();
    private JeiSettingsImpl jeiSettings;

    public GuiContext(ModularScreen screen) {
        this.screen = screen;
        this.hoveredWidgets = new HoveredIterable(this.screen.getPanelManager());
        this.mc = Minecraft.func_71410_x();
        this.font = this.mc.field_71466_p;
    }

    public boolean isAbove(IGuiElement widget) {
        return widget.getArea().isInside(this.mouseX, this.mouseY);
    }

    public boolean isHovered() {
        return this.hovered != null;
    }

    public boolean isHovered(IGuiElement guiElement) {
        return this.isHovered() && this.hovered == guiElement;
    }

    public boolean isHoveredFor(IGuiElement guiElement, int ticks) {
        return this.isHovered(guiElement) && this.timeHovered / 3 >= ticks;
    }

    @Nullable
    public IGuiElement getHovered() {
        return this.hovered;
    }

    public Iterable<IGuiElement> getAllBelowMouse() {
        return this.hoveredWidgets;
    }

    public boolean isFocused() {
        return this.focusedWidget.getElement() != null;
    }

    public boolean isFocused(IFocusedWidget widget) {
        return this.focusedWidget.getElement() == widget;
    }

    public LocatedWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void focus(IFocusedWidget widget) {
        this.focus(LocatedWidget.of((IWidget)((Object)widget)));
    }

    public void focus(@NotNull LocatedWidget widget) {
        IFocusedWidget focusedWidget;
        if (this.focusedWidget.getElement() == widget.getElement()) {
            return;
        }
        if (widget.getElement() != null && !(widget.getElement() instanceof IFocusedWidget)) {
            throw new IllegalArgumentException();
        }
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onRemoveFocus(this);
            this.screen.setFocused(false);
        }
        this.focusedWidget = widget;
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onFocus(this);
            this.screen.setFocused(true);
        }
    }

    public void removeFocus() {
        this.focus(LocatedWidget.EMPTY);
    }

    public boolean focusNext(IWidget parent) {
        return this.focus(parent, -1, 1);
    }

    public boolean focusPrevious(IWidget parent) {
        return this.focus(parent, -1, -1);
    }

    public boolean focus(IWidget parent, int index, int factor) {
        return this.focus(parent, index, factor, false);
    }

    public boolean focus(IWidget widget, int index, int factor, boolean stop) {
        List<IWidget> children = widget.getChildren();
        factor = factor >= 0 ? 1 : -1;
        index += factor;
        while (index >= 0 && index < children.size()) {
            IWidget child = children.get(index);
            if (child.isEnabled()) {
                int start;
                if (child instanceof IFocusedWidget) {
                    IFocusedWidget focusedWidget1 = (IFocusedWidget)((Object)child);
                    this.focus(focusedWidget1);
                    return true;
                }
                int n = start = factor > 0 ? -1 : child.getChildren().size();
                if (this.focus(child, start, factor, true)) {
                    return true;
                }
            }
            index += factor;
        }
        IWidget grandparent = widget.getParent();
        boolean isRoot = grandparent instanceof ModularPanel;
        if (!stop && (isRoot || grandparent.canBeSeen(this))) {
            List<IWidget> siblings = grandparent.getChildren();
            if (this.focus(grandparent, siblings.indexOf(widget), factor)) {
                return true;
            }
            if (isRoot) {
                return this.focus(grandparent, factor > 0 ? -1 : siblings.size() - 1, factor);
            }
        }
        return false;
    }

    public boolean hasDraggable() {
        return this.draggable != null;
    }

    public boolean isMouseItemEmpty() {
        return this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
    }

    @ApiStatus.Internal
    public boolean onMousePressed(int button) {
        if ((button == 0 || button == 1) && this.isMouseItemEmpty() && this.hasDraggable()) {
            this.dropDraggable();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean onMouseReleased(int button) {
        if (button == this.lastButton && this.isMouseItemEmpty() && this.hasDraggable()) {
            long time = Minecraft.func_71386_F();
            if (time - this.lastClickTime < 200L) {
                return false;
            }
            this.dropDraggable();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void dropDraggable() {
        this.draggable.applyMatrix(this);
        this.draggable.getElement().onDragEnd(this.draggable.getElement().canDropHere(this.getAbsMouseX(), this.getAbsMouseY(), this.hovered));
        this.draggable.getElement().setMoving(false);
        this.draggable.unapplyMatrix(this);
        this.draggable = null;
        this.lastButton = -1;
        this.lastClickTime = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public boolean onHoveredClick(int button, LocatedWidget hovered) {
        LocatedElement<IDraggable> draggable;
        if (button != 0 && button != 1 || !this.isMouseItemEmpty() || this.hasDraggable()) return false;
        IWidget widget = (IWidget)hovered.getElement();
        if (widget instanceof IDraggable) {
            IDraggable iDraggable = (IDraggable)((Object)widget);
            draggable = new LocatedElement<IDraggable>(iDraggable, hovered.getTransformationMatrix());
        } else {
            if (!(widget instanceof ModularPanel)) return false;
            ModularPanel panel = (ModularPanel)widget;
            if (!panel.isDraggable()) return false;
            if (!panel.flex().hasFixedSize()) {
                throw new IllegalStateException("Panel must have a fixed size. It can't specify left AND right or top AND bottom!");
            }
            draggable = new LocatedElement<DraggablePanelWrapper>(new DraggablePanelWrapper(panel), TransformationMatrix.EMPTY);
        }
        if (!draggable.getElement().onDragStart(button)) return false;
        draggable.getElement().setMoving(true);
        this.draggable = draggable;
        this.lastButton = button;
        this.lastClickTime = Minecraft.func_71386_F();
        return true;
    }

    @ApiStatus.Internal
    public void drawDraggable() {
        if (this.hasDraggable()) {
            this.draggable.applyMatrix(this);
            this.draggable.getElement().drawMovingState(this, this.partialTicks);
            this.draggable.unapplyMatrix(this);
        }
    }

    @ApiStatus.Internal
    public void updateState(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTicks = partialTicks;
    }

    @ApiStatus.Internal
    public void updateEventState() {
        this.mouseButton = Mouse.getEventButton();
        this.mouseWheel = Mouse.getEventDWheel();
        this.keyCode = Keyboard.getEventKey();
        this.typedChar = Keyboard.getEventCharacter();
    }

    @ApiStatus.Internal
    public void onFrameUpdate() {
        this.updateEventState();
        IWidget hovered = this.screen.getPanelManager().getTopWidget();
        if (this.hasDraggable() && (this.lastDragX != this.mouseX || this.lastDragY != this.mouseY)) {
            this.lastDragX = this.mouseX;
            this.lastDragY = this.mouseY;
            this.draggable.applyMatrix(this);
            this.draggable.getElement().onDrag(this.lastButton, this.lastClickTime);
            this.draggable.unapplyMatrix(this);
        }
        if (this.hovered != hovered) {
            if (this.hovered != null) {
                this.hovered.onMouseEndHover();
            }
            this.hovered = hovered;
            this.timeHovered = 0;
            if (this.hovered != null) {
                this.hovered.onMouseStartHover();
                IGuiElement iGuiElement = this.hovered;
                if (iGuiElement instanceof IVanillaSlot) {
                    IVanillaSlot vanillaSlot = (IVanillaSlot)((Object)iGuiElement);
                    ((GuiContainerAccessor)((Object)this.screen.getScreenWrapper())).setHoveredSlot(vanillaSlot.getVanillaSlot());
                } else {
                    ((GuiContainerAccessor)((Object)this.screen.getScreenWrapper())).setHoveredSlot(null);
                }
            }
        } else {
            ++this.timeHovered;
        }
    }

    public void tick() {
        ++this.tick;
    }

    public long getTick() {
        return this.tick;
    }

    public int getMouseX() {
        return this.transformX(this.mouseX, this.mouseY);
    }

    public int getMouseY() {
        return this.transformY(this.mouseX, this.mouseY);
    }

    public int getMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getMouseX() : this.getMouseY();
    }

    public int getAbsMouseX() {
        return this.mouseX;
    }

    public int getAbsMouseY() {
        return this.mouseY;
    }

    public int getAbsMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getAbsMouseX() : this.getAbsMouseY();
    }

    public int unTransformMouseX() {
        return this.unTransformX(this.getAbsMouseX(), this.getAbsMouseY());
    }

    public int unTransformMouseY() {
        return this.unTransformY(this.getAbsMouseX(), this.getAbsMouseY());
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char getTypedChar() {
        return this.typedChar;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public ITheme getTheme() {
        return this.screen.getCurrentTheme();
    }

    public JeiSettingsImpl getJeiSettings() {
        if (this.jeiSettings == null) {
            throw new IllegalStateException("The screen is not yet initialised!");
        }
        return this.jeiSettings;
    }

    @ApiStatus.Internal
    public void setJeiSettings(JeiSettingsImpl jeiSettings) {
        if (this.jeiSettings != null) {
            throw new IllegalStateException("Tried to set jei settings twice");
        }
        this.jeiSettings = jeiSettings;
    }

    private static class HoveredIterable
    implements Iterable<IGuiElement> {
        private final PanelManager panelManager;

        private HoveredIterable(PanelManager panelManager) {
            this.panelManager = panelManager;
        }

        @Override
        @NotNull
        public Iterator<IGuiElement> iterator() {
            return new Iterator<IGuiElement>(){
                private final Iterator<ModularPanel> panelIt;
                private Iterator<LocatedWidget> widgetIt;
                {
                    this.panelIt = panelManager.getOpenPanels().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.widgetIt == null) {
                        if (!this.panelIt.hasNext()) {
                            return false;
                        }
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return this.widgetIt.hasNext();
                }

                @Override
                public IGuiElement next() {
                    if (this.widgetIt == null || !this.widgetIt.hasNext()) {
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return (IGuiElement)this.widgetIt.next().getElement();
                }
            };
        }
    }
}

