/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import java.text.DecimalFormat;

public class NumberFormat {
    public static final DecimalFormat FORMAT = new DecimalFormat("0.###");
    private static final double[] FACTORS_HIGH = new double[]{1000.0, 1000000.0, 1.0E9, 1.0E12, 1.0E15, 1.0E18, 1.0E21, 1.0E24};
    private static final double[] FACTORS_LOW = new double[]{0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18, 1.0E-21, 1.0E-24};
    private static final String[] SUFFIX_HIGH = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final String[] SUFFIX_LOW = new String[]{"m", "u", "n", "p", "f", "a", "z", "y"};

    public static String formatWithMaxDigits(double value) {
        return NumberFormat.format(value, 4, true);
    }

    public static String formatWithMaxDigits(double value, int maxDigits) {
        return NumberFormat.format(value, maxDigits, true);
    }

    public static String formatWithMaxDecimals(double value, int decimals) {
        return NumberFormat.format(value, decimals, false);
    }

    private static String format(double value, int precision, boolean maxDigits) {
        int n = FACTORS_HIGH.length - 1;
        if (value >= 1000.0) {
            int index;
            for (index = 0; index < n && !(value < FACTORS_HIGH[index + 1]); ++index) {
            }
            return NumberFormat.formatToString(value / FACTORS_HIGH[index], precision, maxDigits, SUFFIX_HIGH[index]);
        }
        if (value < 1.0) {
            int index;
            for (index = 0; index < n && !(value >= FACTORS_LOW[index]); ++index) {
            }
            return NumberFormat.formatToString(value / FACTORS_LOW[index], precision, maxDigits, SUFFIX_LOW[index]);
        }
        return NumberFormat.formatToString(value, precision, maxDigits, "");
    }

    private static String formatToString(double value, int precision, boolean maxDigits, String suffix) {
        String[] parts;
        if (maxDigits && (parts = String.valueOf(value).split("\\.")).length > 1) {
            precision -= parts[0].length();
        }
        FORMAT.setMaximumFractionDigits(precision);
        return FORMAT.format(value) + suffix;
    }

    public static double getFactorForSuffix(char suffix) {
        String s;
        int i;
        for (i = 0; i < SUFFIX_HIGH.length; ++i) {
            s = SUFFIX_HIGH[i];
            if (s.charAt(0) != suffix) continue;
            return FACTORS_HIGH[i];
        }
        for (i = 0; i < SUFFIX_LOW.length; ++i) {
            s = SUFFIX_LOW[i];
            if (s.charAt(0) != suffix) continue;
            return FACTORS_LOW[i];
        }
        return 0.0;
    }

    public static double getFactorForSuffix(String suffix) {
        return NumberFormat.getFactorForSuffix(suffix.charAt(0));
    }
}

