/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.WidgetTree;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;

public abstract class PanelSyncHandler
extends SyncHandler {
    private final ModularPanel mainPanel;
    private ModularPanel openedPanel;

    protected PanelSyncHandler(ModularPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    public abstract ModularPanel createUI(ModularPanel var1, GuiSyncManager var2);

    public void openPanel() {
        this.openPanel(true);
    }

    private void openPanel(boolean syncToServer) {
        boolean client = this.getSyncManager().isClient();
        if (syncToServer && client) {
            this.syncToServer(0);
            return;
        }
        ModularPanel panel = Objects.requireNonNull(this.createUI(this.mainPanel, this.getSyncManager()));
        if (panel == this.mainPanel) {
            throw new IllegalArgumentException("New panel must not be the main panel!");
        }
        WidgetTree.collectSyncValues(this.getSyncManager(), panel);
        if (client && !this.mainPanel.getScreen().isPanelOpen(panel.getName())) {
            this.mainPanel.getScreen().openPanel(panel);
            this.openedPanel = panel;
        }
    }

    public void closePanel() {
        if (this.getSyncManager().isClient()) {
            if (this.openedPanel != null) {
                this.openedPanel.closeIfOpen(true);
            }
        } else {
            this.syncToClient(2);
        }
        this.openedPanel = null;
    }

    public boolean isPanelOpen() {
        return this.openedPanel != null && (!this.getSyncManager().isClient() || this.openedPanel.isOpen());
    }

    @Override
    public void readOnClient(int i, PacketBuffer packetBuffer) throws IOException {
        if (i == 1) {
            this.openPanel(false);
        } else if (i == 2) {
            this.closePanel();
        }
    }

    @Override
    public void readOnServer(int i, PacketBuffer packetBuffer) throws IOException {
        if (i == 0) {
            this.openPanel(false);
            this.syncToClient(1);
        }
    }
}

