/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.sizer;

import java.util.function.DoubleSupplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Unit {
    public static final byte UNUSED = -2;
    public static final byte DEFAULT = -1;
    public static final byte START = 0;
    public static final byte END = 1;
    public static final byte SIZE = 2;
    private boolean autoAnchor = true;
    private float value = 0.0f;
    private DoubleSupplier valueSupplier = null;
    private Measure measure = Measure.PIXEL;
    private float anchor = 0.0f;
    private int offset = 0;
    public byte type = (byte)-2;

    public void reset() {
        this.type = (byte)-2;
        this.autoAnchor = true;
        this.value = 0.0f;
        this.valueSupplier = null;
        this.measure = Measure.PIXEL;
        this.anchor = 0.0f;
        this.offset = 0;
    }

    public void setValue(float value) {
        this.value = value;
        this.valueSupplier = null;
    }

    public void setValue(DoubleSupplier valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public float getValue() {
        return this.valueSupplier == null ? this.value : (float)this.valueSupplier.getAsDouble();
    }

    public float getAnchor() {
        float val = this.getValue();
        return this.isAutoAnchor() && this.isRelative() && val < 1.0f ? val : this.anchor;
    }

    public boolean isAutoAnchor() {
        return this.autoAnchor;
    }

    public int getOffset() {
        return this.offset;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void setAnchor(float anchor) {
        this.anchor = anchor;
    }

    public void setAutoAnchor(boolean autoAnchor) {
        this.autoAnchor = autoAnchor;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public boolean isRelative() {
        return this.measure == Measure.RELATIVE;
    }

    public static enum Measure {
        PIXEL,
        RELATIVE;

    }
}

