/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.client.rendering.helpers;

import appeng.api.util.AEColor;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.client.rendering.helpers.RenderUtils;
import co.neeve.nae2.client.rendering.helpers.beamformer.IBeamFormerRenderer;
import co.neeve.nae2.client.rendering.helpers.beamformer.renderers.DeprecatedBeamFormerRenderer;
import co.neeve.nae2.client.rendering.helpers.beamformer.renderers.ModernBeamFormerRenderer;
import co.neeve.nae2.client.rendering.helpers.beamformer.renderers.NativeBeamFormerRenderer;
import co.neeve.nae2.common.interfaces.IBeamFormer;
import java.util.EnumSet;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class BeamFormerRenderHelper {
    private static final double MIN_SCALE = 0.15;
    private static final WeakHashMap<IBeamFormer, StaticBloomMetadata> META_CACHE = new WeakHashMap();
    private static final EnumSet<EnumFacing> FACINGS_ALONG_Z = EnumSet.of(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST);
    private static final EnumSet<EnumFacing> FACINGS_ALONG_X = EnumSet.of(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH);
    private static final EnumSet<EnumFacing> FACINGS_ALONG_Y = EnumSet.of(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST);
    private static final IBeamFormerRenderer RENDERER;

    public static boolean shouldRenderDynamic(IBeamFormer partBeamFormer) {
        return RENDERER.shouldRenderDynamic(partBeamFormer);
    }

    public static void renderDynamic(IBeamFormer partBeamFormer, double x, double y, double z, float partialTicks) {
        RENDERER.renderDynamic(partBeamFormer, x, y, z, partialTicks);
    }

    public static float @NotNull [] getColor(IBeamFormer partBeamFormer) {
        AEColor color = partBeamFormer.getColor();
        float scale = 255.0f;
        return new float[]{(float)(color.mediumVariant >> 16 & 0xFF) / scale, (float)(color.mediumVariant >> 8 & 0xFF) / scale, (float)(color.mediumVariant & 0xFF) / scale};
    }

    public static void drawCube(BufferBuilder bufferBuilder, double x, double y, double z, double length, StaticBloomMetadata result, float[] rgb) {
        double scaleZ;
        double scaleY;
        double scaleX;
        EnumSet<EnumFacing> facings;
        if (result.dx != 0) {
            facings = FACINGS_ALONG_X;
            scaleX = Math.max(0.15, Math.abs((double)result.dx * length + (double)result.dx * 0.25));
            scaleY = 0.15;
            scaleZ = 0.15;
        } else if (result.dy() != 0) {
            facings = FACINGS_ALONG_Y;
            scaleX = 0.15;
            scaleY = Math.max(0.15, Math.abs((double)result.dy * length + (double)result.dy * 0.25));
            scaleZ = 0.15;
        } else if (result.dz() != 0) {
            facings = FACINGS_ALONG_Z;
            scaleX = 0.15;
            scaleY = 0.15;
            scaleZ = Math.max(0.15, Math.abs((double)result.dz * length + (double)result.dz * 0.25));
        } else {
            return;
        }
        RenderUtils.drawCube(bufferBuilder, x, y, z, scaleX, scaleY, scaleZ, rgb, facings);
    }

    @NotNull
    public static StaticBloomMetadata getBloomMetadata(IBeamFormer partBeamFormer) {
        StaticBloomMetadata metadata = META_CACHE.getOrDefault(partBeamFormer, null);
        if (metadata != null) {
            return metadata;
        }
        EnumFacing facing = partBeamFormer.getDirection();
        int dx = facing.func_82601_c();
        int dy = facing.func_96559_d();
        int dz = facing.func_82599_e();
        float pitch = (float)Math.atan2(Math.sqrt(dx * dx + dz * dz), dy) * 57.295776f;
        float yaw = (float)(180.0 - Math.atan2(dz, dx) * 57.2957763671875 - 90.0);
        StaticBloomMetadata newMetadata = new StaticBloomMetadata(dx, dy, dz, pitch, yaw);
        META_CACHE.put(partBeamFormer, newMetadata);
        return newMetadata;
    }

    public static void init(IBeamFormer partBeamFormer) {
        RENDERER.init(partBeamFormer);
    }

    static {
        IBeamFormerRenderer renderer = ModernBeamFormerRenderer.create();
        if (renderer != null) {
            NAE2.logger().info("Modern GregTech bloom API found. Beam formers will be rendered using that.");
        } else {
            renderer = DeprecatedBeamFormerRenderer.create();
            if (renderer != null) {
                NAE2.logger().warn("Deprecated GregTech bloom API found. Beam formers will be rendered using that.");
            } else {
                renderer = NativeBeamFormerRenderer.create();
                NAE2.logger().warn("No GregTech bloom API found. Beam formers will fall back to beacon rendering.");
            }
        }
        RENDERER = renderer;
    }

    public static final class StaticBloomMetadata {
        private final int dx;
        private final int dy;
        private final int dz;
        private final float pitch;
        private final float yaw;

        public StaticBloomMetadata(int dx, int dy, int dz, float pitch, float yaw) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public String toString() {
            return "StaticBloomMetadata[" + "dx=" + this.dx + "," + "dy=" + this.dy + "," + "dz=" + this.dz + "," + "pitch=" + this.pitch + "," + "yaw=" + this.yaw + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.dx;
            result = 31 * result + this.dy;
            result = 31 * result + this.dz;
            result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
            result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((StaticBloomMetadata)arg0).dx != this.dx) {
                return false;
            }
            if (((StaticBloomMetadata)arg0).dy != this.dy) {
                return false;
            }
            if (((StaticBloomMetadata)arg0).dz != this.dz) {
                return false;
            }
            if (((StaticBloomMetadata)arg0).pitch != this.pitch) {
                return false;
            }
            return ((StaticBloomMetadata)arg0).yaw == this.yaw;
            {
            }
        }

        public int dx() {
            return this.dx;
        }

        public int dy() {
            return this.dy;
        }

        public int dz() {
            return this.dz;
        }

        public float pitch() {
            return this.pitch;
        }

        public float yaw() {
            return this.yaw;
        }
    }
}

