/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.containers;

import appeng.api.config.Upgrades;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.ItemStackHelper;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.misc.ItemEncodedPattern;
import appeng.items.tools.ToolNetworkTool;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import co.neeve.nae2.client.gui.implementations.GuiPatternMultiTool;
import co.neeve.nae2.common.enums.PatternMultiToolInventories;
import co.neeve.nae2.common.enums.PatternMultiToolTabs;
import co.neeve.nae2.common.interfaces.IContainerPatternMultiTool;
import co.neeve.nae2.common.items.patternmultitool.ObjPatternMultiTool;
import co.neeve.nae2.common.slots.SlotPatternMultiTool;
import co.neeve.nae2.common.slots.SlotPatternMultiToolUpgrade;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ContainerPatternMultiTool
extends AEBaseContainer
implements IAEAppEngInventory,
IContainerPatternMultiTool {
    private final ObjPatternMultiTool patternMultiTool;
    private final InventoryPlayer inventoryPlayer;
    private final List<AppEngSlot> patternMultiToolSlots = new ArrayList<AppEngSlot>();
    private final IInterfaceHost iface;
    @GuiSync(value=0)
    public PatternMultiToolInventories viewingInventory = PatternMultiToolInventories.PMT;
    @GuiSync(value=1)
    public PatternMultiToolTabs viewingTab;
    @SideOnly(value=Side.CLIENT)
    private HashMap<AppEngSlot, ValidatonResult> highlightedSlots;
    private NetworkToolViewer tbInventory;
    private List<SlotFake> srSlots;

    public ContainerPatternMultiTool(InventoryPlayer ip, ObjPatternMultiTool te) {
        super(ip, (Object)te);
        this.patternMultiTool = te;
        this.inventoryPlayer = ip;
        this.lockPlayerInventorySlot(ip.field_70461_c);
        this.iface = te.getInterface();
        if (this.iface != null) {
            this.viewingInventory = PatternMultiToolInventories.INTERFACE;
        }
        this.viewingTab = te.getTab();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.highlightedSlots = new HashMap();
        }
        this.addSlots();
    }

    public HashMap<AppEngSlot, ValidatonResult> getHighlightedSlots() {
        return this.highlightedSlots;
    }

    public List<SlotFake> getSearchReplaceSlots() {
        return this.srSlots;
    }

    public boolean hasToolbox() {
        return this.tbInventory != null;
    }

    @Override
    public boolean isViewingInterface() {
        return this.viewingInventory == PatternMultiToolInventories.INTERFACE;
    }

    @Override
    @Nonnull
    public IItemHandler getPatternInventory() {
        IItemHandler result = null;
        switch (this.viewingInventory) {
            case PMT: {
                result = this.patternMultiTool.getPatternInventory();
                break;
            }
            case INTERFACE: {
                result = this.iface.getInventoryByName("patterns");
            }
        }
        return result;
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("viewingInventory") || field.equals("viewingTab")) {
            GuiScreen guiScreen;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (guiScreen = Minecraft.func_71410_x().field_71462_r) instanceof GuiPatternMultiTool) {
                GuiPatternMultiTool gpmt = (GuiPatternMultiTool)guiScreen;
                if (field.equals("viewingTab")) {
                    assert (this.getPatternMultiToolObject() != null);
                    this.getPatternMultiToolObject().setTab((PatternMultiToolTabs)((Object)newValue));
                }
                gpmt.setupTabSpecificButtons();
            }
            this.addSlots();
        }
    }

    private void addSlots() {
        int v;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.patternMultiToolSlots.clear();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.highlightedSlots.clear();
        }
        this.srSlots = null;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                SlotPatternMultiTool slot = new SlotPatternMultiTool(this.getPatternInventory(), this, y * 9 + x, 8 + x * 18, 19 + y * 18, y, this.getInventoryPlayer());
                slot.setStackLimit(this.viewingInventory == PatternMultiToolInventories.INTERFACE ? 1 : 64);
                this.func_75146_a((Slot)slot);
                this.patternMultiToolSlots.add((AppEngSlot)slot);
            }
        }
        this.setupUpgrades();
        InventoryPlayer pi = this.getPlayerInv();
        World w = this.inventoryPlayer.field_70458_d.field_70170_p;
        for (v = 0; v < pi.func_70302_i_(); ++v) {
            ItemStack pii = pi.func_70301_a(v);
            if (pii.func_190926_b() || !(pii.func_77973_b() instanceof ToolNetworkTool)) continue;
            this.lockPlayerInventorySlot(v);
            this.tbInventory = (NetworkToolViewer)((IGuiItem)pii.func_77973_b()).getGuiObject(pii, w, new BlockPos(0, 0, 0));
            break;
        }
        if (this.getViewingTab() == PatternMultiToolTabs.SEARCH_REPLACE) {
            this.srSlots = new ArrayList<SlotFake>();
            IItemHandler inv = this.patternMultiTool.getSearchReplaceInventory();
            this.srSlots.add((SlotFake)this.func_75146_a((Slot)new SlotFakeTypeOnly(inv, 0, 8, 95)));
            this.srSlots.add((SlotFake)this.func_75146_a((Slot)new SlotFakeTypeOnly(inv, 1, 54, 95)));
        }
        if (this.hasToolbox()) {
            for (v = 0; v < 3; ++v) {
                for (int u = 0; u < 3; ++u) {
                    this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, this.tbInventory.getInternalInventory(), u + v * 3, 186 + u * 18, 125 + v * 18, this.getInventoryPlayer()).setPlayerSide());
                }
            }
        }
        this.bindPlayerInventory(this.inventoryPlayer, 0, 125);
    }

    @Nonnull
    public UpgradeInventory getUpgradeInventory() {
        UpgradeInventory result = null;
        switch (this.viewingInventory) {
            case PMT: {
                result = this.patternMultiTool.getUpgradeInventory();
                break;
            }
            case INTERFACE: {
                result = (UpgradeInventory)this.iface.getInventoryByName("upgrades");
            }
        }
        return result;
    }

    public boolean isBoundToInterface() {
        return this.iface != null;
    }

    public void setupUpgrades() {
        UpgradeInventory ui = this.getUpgradeInventory();
        for (int upgradeSlot = 0; upgradeSlot < ui.getSlots(); ++upgradeSlot) {
            SlotPatternMultiToolUpgrade slot = new SlotPatternMultiToolUpgrade(SlotRestrictedInput.PlacableItemType.UPGRADES, (IItemHandler)ui, this, upgradeSlot, 187, 8 + upgradeSlot * 18, this.getInventoryPlayer());
            slot.setNotDraggable();
            this.func_75146_a((Slot)slot);
        }
    }

    public void func_75142_b() {
        TileEntity tileEntity;
        if (this.iface != null && ((tileEntity = this.iface.getTileEntity()) == null || tileEntity != tileEntity.func_145831_w().func_175625_s(tileEntity.func_174877_v()))) {
            this.setValidContainer(false);
            super.func_75142_b();
            return;
        }
        ItemStack currentItem = this.getPlayerInv().func_70448_g();
        ItemStack toolInvItemStack = this.patternMultiTool.getItemStack();
        if (!ItemStack.func_179545_c((ItemStack)toolInvItemStack, (ItemStack)currentItem)) {
            if (!currentItem.func_190926_b()) {
                this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, toolInvItemStack);
            }
            this.setValidContainer(false);
        }
        super.func_75142_b();
    }

    public void onSlotChange(Slot s) {
        if (this.viewingInventory == PatternMultiToolInventories.INTERFACE) {
            IItemHandler patterns = this.getPatternInventory();
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            int maxSlots = ((UpgradeInventory)this.iface.getInventoryByName("upgrades")).getInstalledUpgrades(Upgrades.PATTERN_EXPANSION) * 9;
            for (int invSlot = 0; invSlot < patterns.getSlots(); ++invSlot) {
                ItemStack is = patterns.getStackInSlot(invSlot);
                if (!(is.func_77973_b() instanceof ICraftingPatternItem)) {
                    dropList.add(patterns.extractItem(invSlot, Integer.MAX_VALUE, false));
                    continue;
                }
                if (invSlot <= 8 + maxSlots || is.func_190926_b()) continue;
                dropList.add(patterns.extractItem(invSlot, Integer.MAX_VALUE, false));
            }
            if (dropList.size() > 0) {
                TileEntity tileEntity = this.iface.getTileEntity();
                World world = tileEntity.func_145831_w();
                BlockPos blockPos = tileEntity.func_174877_v();
                Platform.spawnDrops((World)world, (BlockPos)blockPos, dropList);
            }
        }
        if (this.getViewingTab() == PatternMultiToolTabs.SEARCH_REPLACE) {
            if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
                return;
            }
            this.highlightedSlots.clear();
            ContainerPatternMultiTool host = this;
            IItemHandler srInv = host.getSearchReplaceInventory();
            if (srInv == null) {
                return;
            }
            ItemStack itemA = srInv.getStackInSlot(0);
            ItemStack itemB = srInv.getStackInSlot(1);
            if (itemA.func_190926_b() || itemB.func_190926_b()) {
                return;
            }
            NBTTagCompound itemBData = ItemStackHelper.stackToNBT((ItemStack)itemB);
            InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (AppEngSlot slot : this.patternMultiToolSlots) {
                ValidatonResult result;
                block20: {
                    NBTTagCompound nbt;
                    ItemStack is = slot.func_75211_c();
                    if (!(is.func_77973_b() instanceof ItemEncodedPattern) || (nbt = is.func_77978_p()) == null) continue;
                    boolean ae2fc = Platform.isModLoaded((String)"ae2fc") && is.func_77973_b() instanceof ItemFluidEncodedPattern;
                    String countTag = ae2fc ? "Cnt" : "Count";
                    boolean isCrafting = nbt.func_74767_n("crafting");
                    result = null;
                    NBTTagList tagIn = (NBTTagList)nbt.func_74781_a("in").func_74737_b();
                    NBTTagList tagOut = (NBTTagList)nbt.func_74781_a("out").func_74737_b();
                    ArrayList<NBTTagList> lists = new ArrayList<NBTTagList>();
                    lists.add(tagIn);
                    if (!isCrafting) {
                        lists.add(tagOut);
                    }
                    FluidStack fluidStackIn = FluidUtil.getFluidContained((ItemStack)itemA);
                    FluidStack fluidStackOut = FluidUtil.getFluidContained((ItemStack)itemB);
                    boolean fluidReplacement = ae2fc && fluidStackIn != null && fluidStackOut != null;
                    for (NBTTagList list : lists) {
                        int idx = 0;
                        for (NBTBase tag : list.func_74737_b()) {
                            FluidStack fluidStack;
                            NBTTagCompound compound = (NBTTagCompound)tag;
                            ItemStack stack = ItemStackHelper.stackFromNBT((NBTTagCompound)compound);
                            if (itemA.func_77969_a(stack)) {
                                result = ValidatonResult.OK;
                                if (!isCrafting) continue;
                                NBTBase count = compound.func_74781_a(countTag).func_74737_b();
                                NBTTagCompound data = itemBData.func_74737_b();
                                data.func_74782_a(countTag, count);
                                list.func_150304_a(idx, (NBTBase)data);
                            } else if (fluidReplacement && stack.func_77973_b() instanceof ItemFluidDrop && fluidStackIn.isFluidEqual(fluidStack = ItemFluidDrop.getFluidStack((ItemStack)stack))) {
                                result = ValidatonResult.OK;
                            }
                            ++idx;
                        }
                    }
                    if (result == null) continue;
                    if (isCrafting) {
                        try {
                            if (tagIn.func_74745_c() != 9) {
                                result = ValidatonResult.ERROR;
                            }
                            World w = this.inventoryPlayer.field_70458_d.field_70170_p;
                            crafting.func_174888_l();
                            for (int j = 0; j < tagIn.func_74745_c(); ++j) {
                                ItemStack is1 = ItemStackHelper.stackFromNBT((NBTTagCompound)((NBTTagCompound)tagIn.func_179238_g(j)));
                                crafting.func_70299_a(j, is1);
                            }
                            if (null != CraftingManager.func_192413_b((InventoryCrafting)crafting, (World)w)) break block20;
                            result = ValidatonResult.ERROR;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                }
                this.highlightedSlots.put(slot, result);
            }
        }
        super.func_75142_b();
    }

    public void saveChanges() {
        if (Platform.isServer()) {
            this.patternMultiTool.saveChanges();
        }
    }

    public void onChangeInventory(IItemHandler iItemHandler, int i, InvOperation invOperation, ItemStack itemStack, ItemStack itemStack1) {
    }

    @Override
    public boolean isPatternRowEnabled(int i) {
        return i <= this.getInstalledCapacityUpgrades();
    }

    public int getInstalledCapacityUpgrades() {
        Upgrades which = null;
        UpgradeInventory ui = this.getUpgradeInventory();
        switch (this.viewingInventory) {
            case PMT: {
                which = Upgrades.CAPACITY;
                break;
            }
            case INTERFACE: {
                which = Upgrades.PATTERN_EXPANSION;
            }
        }
        return ui.getInstalledUpgrades(which);
    }

    @Override
    public boolean canTakeStack() {
        int slices;
        ArrayList inventory = Lists.newArrayList((Iterable)((AppEngInternalInventory)this.getPatternInventory()));
        int lockedUpgrades = slices = inventory.size() / 9;
        int installedUpgrades = this.getInstalledCapacityUpgrades();
        for (int i = slices - 1; i >= 0 && inventory.subList(i * 9, i * 9 + 9).stream().allMatch(ItemStack::func_190926_b); --i) {
            --lockedUpgrades;
        }
        return installedUpgrades >= lockedUpgrades;
    }

    @Override
    public ObjPatternMultiTool getPatternMultiToolObject() {
        return this.patternMultiTool;
    }

    @Override
    public void toggleInventory() {
        this.viewingInventory = this.viewingInventory == PatternMultiToolInventories.PMT ? PatternMultiToolInventories.INTERFACE : PatternMultiToolInventories.PMT;
        this.addSlots();
    }

    public void switchTab(PatternMultiToolTabs tab) {
        ObjPatternMultiTool patternMultiToolObject = this.getPatternMultiToolObject();
        assert (patternMultiToolObject != null);
        patternMultiToolObject.setTab(tab);
        patternMultiToolObject.saveChanges();
        this.viewingTab = tab;
        this.addSlots();
        this.func_75142_b();
    }

    public PatternMultiToolTabs getViewingTab() {
        assert (this.getPatternMultiToolObject() != null);
        return this.getPatternMultiToolObject().getTab();
    }

    public static enum ValidatonResult {
        OK,
        ERROR;

    }
}

