/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.crafting.patterntransform;

import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import co.neeve.nae2.common.crafting.patterntransform.PatternTransformWrapper;
import co.neeve.nae2.common.crafting.patterntransform.transformers.IPatternTransformer;
import co.neeve.nae2.common.items.NAEBaseItemUpgrade;
import co.neeve.nae2.common.registration.definitions.Upgrades;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Unique;

public class PatternTransform {
    protected static final List<IPatternTransformer> transformers = new ArrayList<IPatternTransformer>();

    public static void registerTransformer(IPatternTransformer transformer) {
        transformers.add(transformer);
    }

    public static ICraftingPatternDetails transform(ICraftingMedium medium, ICraftingPatternDetails pattern) {
        Object[] originalInputs = pattern.getInputs();
        Object[] originalOutputs = pattern.getOutputs();
        Object[] inputs = originalInputs;
        Object[] outputs = originalOutputs;
        for (IPatternTransformer transformer : transformers) {
            if (!transformer.shouldTransform(medium, pattern)) continue;
            inputs = transformer.transformInputs(medium, pattern, (IAEItemStack[])inputs);
            outputs = transformer.transformOutputs(medium, pattern, (IAEItemStack[])outputs);
        }
        if (!Arrays.equals(inputs, originalInputs) || !Arrays.equals(outputs, originalOutputs)) {
            return new PatternTransformWrapper(pattern, (IAEItemStack[])inputs, (IAEItemStack[])outputs);
        }
        return pattern;
    }

    @Unique
    public static boolean isTransformer(ItemStack is) {
        NAEBaseItemUpgrade upgrade;
        Item item = is.func_77973_b();
        return item instanceof NAEBaseItemUpgrade && (upgrade = (NAEBaseItemUpgrade)item).getType(is) == Upgrades.UpgradeType.GREGTECH_CIRCUIT;
    }
}

