/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.helpers.exposer;

import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.interfaces.IExposerHandler;
import co.neeve.nae2.common.interfaces.IExposerHost;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumSet;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposerBootstrapper
implements ICapabilityProvider {
    private final IExposerHost host;
    private final EnumSet<EnumFacing> targets;
    private final Object2ObjectMap<Capability<?>, IExposerHandler<?>> exposers = new Object2ObjectOpenHashMap();

    public ExposerBootstrapper(IExposerHost host, EnumSet<EnumFacing> targets) {
        this.host = host;
        this.targets = targets;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return (facing == null || this.targets.contains(facing)) && NAE2.api().exposer().isCapabilityRegistered(capability);
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(facing == null || this.targets.contains(facing) ? this.exposers.computeIfAbsent(capability, c -> NAE2.api().exposer().createHandler(this.host, (Capability<?>)c)) : null);
    }
}

