/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.helpers.exposer;

import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import co.neeve.nae2.common.interfaces.IExposerHandler;
import co.neeve.nae2.common.interfaces.IExposerHost;
import org.jetbrains.annotations.Nullable;

public abstract class ExposerHandler<T extends IAEStack<T>>
implements IExposerHandler<T>,
IMEMonitorHandlerReceiver<T> {
    protected final IExposerHost host;
    protected final IActionSource mySrc;
    protected final AENetworkProxy proxy;
    protected IMEMonitor<T> monitor;

    public ExposerHandler(IExposerHost host) {
        this.host = host;
        this.mySrc = new MachineSource((IActionHost)this.host);
        this.proxy = this.host.getProxy();
    }

    protected abstract void onMonitorChange(IMEMonitor<T> var1, IMEMonitor<T> var2);

    protected abstract IStorageChannel<T> getStorageChannel();

    @Nullable
    protected IMEMonitor<T> queryMonitor() {
        if (this.proxy.isActive()) {
            try {
                return this.host.getProxy().getStorage().getInventory(this.getStorageChannel());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    protected IItemList<T> getStorageList() {
        if (this.monitor != null) {
            return this.monitor.getStorageList();
        }
        return null;
    }

    protected void updateMonitor() {
        IMEMonitor<T> pendingMonitor = this.queryMonitor();
        if (this.monitor != pendingMonitor) {
            IMEMonitor<T> oldMonitor = this.monitor;
            if (oldMonitor != null) {
                oldMonitor.removeListener((IMEMonitorHandlerReceiver)this);
            }
            this.monitor = pendingMonitor;
            if (pendingMonitor != null) {
                try {
                    this.monitor.addListener((IMEMonitorHandlerReceiver)this, (Object)this.host.getProxy().getGrid());
                }
                catch (GridAccessException ignored) {
                    this.monitor = null;
                }
            }
            this.onMonitorChange(oldMonitor, this.monitor);
        }
    }

    public abstract void postChange(IBaseMonitor<T> var1, Iterable<T> var2, IActionSource var3);

    public abstract void onListUpdate();

    public final boolean isValid(Object effectiveGrid) {
        try {
            return this.host.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException var3) {
            return false;
        }
    }

    public IMEMonitor<T> getMonitor() {
        return this.monitor;
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public AENetworkProxy getProxy() {
        return this.proxy;
    }
}

