/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.items.cells.vc;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.exceptions.MissingDefinitionException;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.features.subfeatures.VoidCellFeatures;
import co.neeve.nae2.common.items.cells.vc.VoidCellInventory;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class VoidCell<T extends IAEStack<T>>
extends AEBaseItem
implements ICellWorkbenchItem {
    private static final NumberFormat decimalFormat = NumberFormat.getInstance();

    public VoidCell() {
        this.func_77625_d(1);
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public CellUpgrades getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return this.getCellInventory(is).getCellConfig();
    }

    public VoidCellInventory<T> getCellInventory(ItemStack stack) {
        return (VoidCellInventory)AEApi.instance().registries().cell().getCellInventory(stack, null, this.getStorageChannel());
    }

    public abstract IStorageChannel<T> getStorageChannel();

    @SideOnly(value=Side.CLIENT)
    protected void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        NBTTagCompound compound;
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        boolean empty = true;
        VoidCellInventory<T> inventory = this.getCellInventory(stack);
        if (inventory != null) {
            CellConfig cc = new CellConfig(stack);
            ObjectArrayList storageList = new ObjectArrayList();
            for (ItemStack is : cc) {
                if (is.func_190926_b()) continue;
                storageList.add((Object)is.func_82833_r());
            }
            if (!storageList.isEmpty()) {
                String list = (this.getIncludeExcludeMode(stack) == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                if (this.isFuzzy(stack)) {
                    lines.add("[" + GuiText.Partitioned.getLocal() + "] - " + list + ' ' + GuiText.Fuzzy.getLocal());
                } else {
                    lines.add("[" + GuiText.Partitioned.getLocal() + "] - " + list + ' ' + GuiText.Precise.getLocal());
                }
                if (this.isSticky(stack)) {
                    lines.add(GuiText.Sticky.getLocal());
                }
                lines.addAll((Collection<String>)storageList);
                empty = false;
            }
        }
        if (empty) {
            lines.add(I18n.func_135052_a((String)"nae2.storage_cell_void.warning.1", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"nae2.storage_cell_void.warning.2", (Object[])new Object[]{GuiText.CellWorkbench.getLocal()}));
        }
        if (VoidCellFeatures.CONDENSER_POWER.isEnabled() && (compound = stack.func_77978_p()) != null) {
            lines.add("");
            lines.add(I18n.func_135052_a((String)"nae2.storage_cell_void.count", (Object[])new Object[]{decimalFormat.format(this.getCondenserPower(stack)), GuiText.Condenser.getLocal()}));
        }
    }

    public boolean isSticky(ItemStack itemStack) {
        return this.getCellInventory(itemStack).isSticky();
    }

    public double getCondenserPower(ItemStack stack) {
        return this.getCellInventory(stack).getCondenserPower();
    }

    public void setCondenserPower(ItemStack stack, double power) {
        this.getCellInventory(stack).setCondenserPower(power);
    }

    public void addCondenserPowerFromInput(ItemStack stack, double power) {
        this.getCellInventory(stack).addCondenserPowerFromInput(power);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        this.disassembleDrive(player.func_184586_b(hand), player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    protected void disassembleDrive(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            if (playerInventory.func_70448_g() == stack && this.getCondenserPower(stack) < 1.0) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                playerInventory.func_70299_a(playerInventory.field_70461_c, ItemStack.field_190927_a);
                ItemStack extraB = ia.addItems(NAE2.definitions().materials().cellPartVoid().maybeStack(1).orElse(ItemStack.field_190927_a));
                if (!extraB.func_190926_b()) {
                    player.func_71019_a(extraB, false);
                }
                this.dropEmptyStorageCellCase(ia, player);
                if (player.field_71069_bz != null) {
                    player.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return this.getCellInventory(is).getFuzzyMode();
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        this.getCellInventory(is).setFuzzyMode(fzMode);
    }

    protected void dropEmptyStorageCellCase(InventoryAdaptor ia, EntityPlayer player) {
        AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
            ItemStack extraA = ia.addItems(is);
            if (!extraA.func_190926_b()) {
                player.func_71019_a(extraA, false);
            }
        });
    }

    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack itemStack) {
        return (ItemStack)AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).orElseThrow(() -> new MissingDefinitionException("Tried to use empty storage cells while basic storage cells are defined."));
    }

    public boolean hasContainerItem(@NotNull ItemStack stack) {
        return AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING);
    }

    protected IncludeExclude getIncludeExcludeMode(ItemStack itemStack) {
        return this.getCellInventory(itemStack).getIncludeExcludeMode();
    }

    protected boolean isFuzzy(ItemStack itemStack) {
        return this.getCellInventory(itemStack).isFuzzy();
    }
}

