/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.registry.builders;

import appeng.api.definitions.IItemDefinition;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.core.features.ItemDefinition;
import appeng.util.Platform;
import co.neeve.nae2.common.features.IFeature;
import co.neeve.nae2.common.integration.jei.NAEJEIPlugin;
import co.neeve.nae2.common.registration.definitions.CreativeTab;
import co.neeve.nae2.common.registration.registry.Registry;
import co.neeve.nae2.common.registration.registry.builders.INAEItemBuilder;
import co.neeve.nae2.common.registration.registry.rendering.NAEItemRendering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NAEItemDefinitionBuilder
implements INAEItemBuilder {
    private final Registry registry;
    private final String registryName;
    private final Supplier<Item> itemSupplier;
    private final List<Function<Item, IBootstrapComponent>> boostrapComponents = new ArrayList<Function<Item, IBootstrapComponent>>();
    @Nullable
    private IFeature[] features = null;
    private Supplier<IBehaviorDispenseItem> dispenserBehaviorSupplier;
    @SideOnly(value=Side.CLIENT)
    private NAEItemRendering itemRendering;
    private CreativeTabs creativeTab = CreativeTab.instance;
    private boolean hidden;

    public NAEItemDefinitionBuilder(Registry registry, String registryName, Supplier<Item> itemSupplier) {
        this.registry = registry;
        this.registryName = registryName;
        this.itemSupplier = itemSupplier;
        if (Platform.isClient()) {
            this.itemRendering = new NAEItemRendering();
        }
    }

    @Override
    public INAEItemBuilder bootstrap(Function<Item, IBootstrapComponent> component) {
        this.boostrapComponents.add(component);
        return this;
    }

    @Override
    public INAEItemBuilder features(IFeature ... features) {
        this.features = features;
        return this;
    }

    @Override
    public INAEItemBuilder creativeTab(CreativeTabs tab) {
        this.creativeTab = tab;
        return this;
    }

    @Override
    public INAEItemBuilder rendering(ItemRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public INAEItemBuilder dispenserBehavior(Supplier<IBehaviorDispenseItem> behavior) {
        this.dispenserBehaviorSupplier = behavior;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(ItemRenderingCustomizer callback) {
        callback.customize((IItemRendering)this.itemRendering);
    }

    @Override
    public INAEItemBuilder hide() {
        this.hidden = true;
        return this;
    }

    @Override
    public ItemDefinition build() {
        if (this.features != null && Arrays.stream(this.features).noneMatch(IFeature::isEnabled)) {
            return new ItemDefinition(this.registryName, null);
        }
        Item item = this.itemSupplier.get();
        item.setRegistryName("nae2", this.registryName);
        ItemDefinition definition = new ItemDefinition(this.registryName, item);
        item.func_77655_b("nae2." + this.registryName);
        if (!this.hidden) {
            item.func_77637_a(this.creativeTab);
        }
        this.boostrapComponents.forEach(component -> this.registry.addBootstrapComponent((IBootstrapComponent)component.apply(item)));
        if (this.dispenserBehaviorSupplier != null) {
            this.registry.addBootstrapComponent((IBootstrapComponent)((IPostInitComponent)side -> {
                IBehaviorDispenseItem behavior = this.dispenserBehaviorSupplier.get();
                BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behavior);
            }));
        }
        this.registry.addBootstrapComponent((IBootstrapComponent)((IItemRegistrationComponent)(side, reg) -> reg.register((IForgeRegistryEntry)item)));
        if (Platform.isClient()) {
            if (this.hidden && Platform.isModLoaded((String)"jei")) {
                NAEJEIPlugin.registerBlacklist((IItemDefinition)definition);
            }
            this.itemRendering.apply(this.registry, item);
        }
        return definition;
    }
}

