/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.tiles;

import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.net.messages.ReconstructorFXPacket;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.items.lens.LensRecipeHandler;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileReconstructionChamber
extends AEBaseInvTile
implements ITickable {
    private final AppEngInternalInventory inputInvInternal;
    private final WrapperFilteredItemHandler outputInv;
    private final WrapperChainedItemHandler publicInv;
    private final EnumMap<EnumFacing, Object> neighbors = new EnumMap(EnumFacing.class);
    private final AppEngInternalInventory outputInvInternal;
    private final WrapperChainedItemHandler internalInv;
    @SideOnly(value=Side.CLIENT)
    private LinkedList<Hologram> holograms;
    private int ticks;
    private ItemStack displayStack = ItemStack.field_190927_a;
    private ItemStack holoStack = ItemStack.field_190927_a;

    public TileReconstructionChamber() {
        if (Platform.isClient()) {
            this.holograms = new LinkedList();
        }
        this.outputInvInternal = new AppEngInternalInventory((IAEAppEngInventory)this, 1, 512){

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                return this.getSlotLimit(0);
            }
        };
        this.inputInvInternal = new AppEngInternalInventory((IAEAppEngInventory)this, 1, 512){

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                return this.getSlotLimit(0);
            }
        };
        WrapperFilteredItemHandler inputInv = new WrapperFilteredItemHandler((IItemHandler)this.inputInvInternal, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler iItemHandler, int i, int i1) {
                return false;
            }

            public boolean allowInsert(IItemHandler iItemHandler, int i, ItemStack itemStack) {
                return true;
            }
        });
        this.outputInv = new WrapperFilteredItemHandler((IItemHandler)this.outputInvInternal, new IAEItemFilter(){

            public boolean allowExtract(IItemHandler iItemHandler, int i, int i1) {
                return true;
            }

            public boolean allowInsert(IItemHandler iItemHandler, int i, ItemStack itemStack) {
                return false;
            }
        });
        this.publicInv = new WrapperChainedItemHandler(new IItemHandler[]{inputInv, this.outputInv});
        this.internalInv = new WrapperChainedItemHandler(new IItemHandler[]{this.inputInvInternal, this.outputInvInternal});
        this.inputInvInternal.setFilter(new IAEItemFilter(){

            public boolean allowExtract(IItemHandler iItemHandler, int i, int i1) {
                return true;
            }

            public boolean allowInsert(IItemHandler iItemHandler, int i, ItemStack itemStack) {
                if (ItemStack.func_77989_b((ItemStack)iItemHandler.getStackInSlot(i), (ItemStack)itemStack)) {
                    return true;
                }
                for (LensConversionRecipe recipe : ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES) {
                    if (!recipe.getInput().apply(itemStack)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        ItemStack[] stacks;
        super.writeToStream(data);
        for (ItemStack stack : stacks = new ItemStack[]{this.displayStack, this.holoStack}) {
            AEItemStack aeis = AEItemStack.fromItemStack((ItemStack)stack);
            data.writeBoolean(aeis != null);
            if (aeis == null) continue;
            aeis.writeToPacket(data);
        }
    }

    public boolean canBeRotated() {
        return false;
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean result = super.readFromStream(data);
        this.displayStack = data.readBoolean() ? AEItemStack.fromPacket((ByteBuf)data).asItemStackRepresentation() : ItemStack.field_190927_a;
        this.holoStack = data.readBoolean() ? AEItemStack.fromPacket((ByteBuf)data).asItemStackRepresentation() : ItemStack.field_190927_a;
        return result;
    }

    public IItemHandler getInputInvRaw() {
        return this.inputInvInternal;
    }

    @NotNull
    public IItemHandler getInternalInventory() {
        return this.publicInv;
    }

    public void onChangeInventory(IItemHandler iItemHandler, int i, InvOperation invOperation, ItemStack removed, ItemStack added) {
        if (!this.outputInv.getStackInSlot(0).func_190926_b()) {
            this.tryEject();
        }
        this.sync();
    }

    private void sync() {
        ItemStack inputStack = this.inputInvInternal.getStackInSlot(0);
        ItemStack outputStack = this.outputInv.getStackInSlot(0);
        ItemStack potentialStack = !inputStack.func_190926_b() ? inputStack : outputStack;
        if (!potentialStack.func_77969_a(this.displayStack)) {
            LensConversionRecipe recipe;
            this.updateDisplayStack(potentialStack);
            if (!outputStack.func_190926_b()) {
                this.updateHoloStack(outputStack);
                return;
            }
            if (!inputStack.func_190926_b() && (recipe = LensRecipeHandler.findMatchingRecipe((ItemStack)inputStack, (Lens)ActuallyAdditionsAPI.lensDefaultConversion)) != null && recipe.getOutput() != null && !recipe.getOutput().func_190926_b()) {
                this.updateHoloStack(recipe.getOutput());
                return;
            }
            this.updateHoloStack(ItemStack.field_190927_a);
        }
    }

    private void updateHoloStack(ItemStack is) {
        this.holoStack = is;
        if (!Platform.isClient()) {
            this.markForUpdate();
        }
    }

    private void updateDisplayStack(ItemStack is) {
        this.displayStack = is;
        if (!Platform.isClient()) {
            this.markForUpdate();
        }
    }

    public void handleConversionRecipe(IAtomicReconstructor reconstructor) {
        ItemStack input = this.inputInvInternal.getStackInSlot(0);
        LensConversionRecipe recipe = LensRecipeHandler.findMatchingRecipe((ItemStack)input, (Lens)reconstructor.getLens());
        if (recipe != null && reconstructor.getEnergy() >= recipe.getEnergyUsed()) {
            ItemStack output = recipe.getOutput();
            if (!StackUtil.isValid((ItemStack)output)) {
                return;
            }
            int itemsPossible = Math.min(reconstructor.getEnergy() / recipe.getEnergyUsed(), input.func_190916_E());
            if (itemsPossible > 0) {
                ItemStack outputCopy = output.func_77946_l();
                outputCopy.func_190920_e(itemsPossible);
                ItemStack remaining = this.outputInvInternal.insertItem(0, outputCopy, false);
                if (remaining.func_190916_E() != outputCopy.func_190916_E()) {
                    int inserted = outputCopy.func_190916_E() - remaining.func_190916_E();
                    reconstructor.extractEnergy(recipe.getEnergyUsed() * inserted);
                    input.func_190918_g(inserted);
                    NAE2.net().sendToAllAround((IMessage)new ReconstructorFXPacket(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                    this.sync();
                }
            }
        }
    }

    public void func_73660_a() {
        this.ticks = (this.ticks + 1) % 20;
        if (this.ticks == 0 && !this.outputInv.getStackInSlot(0).func_190926_b() && this.tryEject()) {
            this.ticks = 0;
        }
    }

    private boolean tryEject() {
        EnumFacing facing;
        ItemStack is = this.outputInv.getStackInSlot(0);
        int originalCount = is.func_190916_E();
        EnumFacing[] enumFacingArray = EnumFacing.values();
        int n = enumFacingArray.length;
        for (int i = 0; i < n && !(is = this.pushTo(is, facing = enumFacingArray[i])).func_190926_b(); ++i) {
        }
        this.outputInv.setStackInSlot(0, is);
        return is.func_190926_b() || is.func_190916_E() != originalCount;
    }

    private ItemStack pushTo(ItemStack output, EnumFacing d) {
        Object capability;
        if (!output.func_190926_b() && (capability = this.neighbors.get(d)) instanceof InventoryAdaptor) {
            int newSize;
            InventoryAdaptor adaptor = (InventoryAdaptor)capability;
            int size = output.func_190916_E();
            int n = newSize = (output = adaptor.addItems(output)).func_190926_b() ? 0 : output.func_190916_E();
            if (size != newSize) {
                this.saveChanges();
            }
        }
        return output;
    }

    public void updateNeighbors() {
        EnumFacing[] var1;
        for (EnumFacing f : var1 = EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
            InventoryAdaptor capability = null;
            if (te != null) {
                capability = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)f.func_176734_d());
            }
            if (capability != null) {
                this.neighbors.put(f, (Object)capability);
                continue;
            }
            this.neighbors.remove(f);
        }
    }

    public void updateNeighbors(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        EnumFacing updateFromFacing;
        if (pos.func_177958_n() != neighbor.func_177958_n()) {
            updateFromFacing = pos.func_177958_n() > neighbor.func_177958_n() ? EnumFacing.WEST : EnumFacing.EAST;
        } else if (pos.func_177956_o() != neighbor.func_177956_o()) {
            updateFromFacing = pos.func_177956_o() > neighbor.func_177956_o() ? EnumFacing.DOWN : EnumFacing.UP;
        } else {
            if (pos.func_177952_p() == neighbor.func_177952_p()) {
                return;
            }
            updateFromFacing = pos.func_177952_p() > neighbor.func_177952_p() ? EnumFacing.NORTH : EnumFacing.SOUTH;
        }
        if (pos.func_177972_a(updateFromFacing).equals((Object)neighbor)) {
            TileEntity te = w.func_175625_s(neighbor);
            InventoryAdaptor capability = null;
            if (te != null) {
                capability = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)updateFromFacing.func_176734_d());
            }
            if (capability != null) {
                this.neighbors.put(updateFromFacing, (Object)capability);
            } else {
                this.neighbors.remove(updateFromFacing);
            }
        }
    }

    public boolean requiresTESR() {
        return true;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnHologram() {
        if (this.holoStack.func_190926_b()) {
            return;
        }
        this.holograms.addFirst(new Hologram(this.holoStack, this.field_145850_b.func_82737_E()));
    }

    @SideOnly(value=Side.CLIENT)
    public List<Hologram> getHolograms() {
        return this.holograms;
    }

    public void onLoad() {
        this.updateNeighbors();
    }

    public WrapperChainedItemHandler getPrivateInv() {
        return this.internalInv;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Hologram {
        private final ItemStack holoStack;
        private final long life;

        public Hologram(ItemStack holoStack, long time) {
            this.holoStack = holoStack;
            this.life = time;
        }

        public static int getMaxLife() {
            return 30;
        }

        public double getStart() {
            return this.life;
        }

        public double getProgress(double time) {
            return Math.min(1.0, Math.max(0.0, (time - this.getStart()) / (double)Hologram.getMaxLife()));
        }

        public ItemStack getHoloStack() {
            return this.holoStack;
        }
    }
}

