/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.server;

import co.neeve.nae2.server.IBlockStateListener;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldListener
implements IWorldEventListener {
    public static WorldListener instance;
    private final Long2ObjectOpenHashMap<IBlockStateListener> blockStateListeners = new Long2ObjectOpenHashMap();

    public WorldListener() {
        instance = this;
    }

    public void registerBlockStateListener(IBlockStateListener listener, Iterable<BlockPos> blocks) {
        for (BlockPos bp : blocks) {
            this.blockStateListeners.put(bp.func_177986_g(), (Object)listener);
        }
    }

    public void unregisterBlockStateListener(IBlockStateListener listener) {
        this.blockStateListeners.entrySet().removeIf(entry -> entry.getValue() == listener);
    }

    public void func_184376_a(@NotNull World worldIn, BlockPos pos, @NotNull IBlockState oldState, @NotNull IBlockState newState, int flags) {
        IBlockStateListener listener = (IBlockStateListener)this.blockStateListeners.get(pos.func_177986_g());
        if (listener != null) {
            listener.notifyBlockUpdate(worldIn, pos, oldState, newState, flags);
        }
    }

    public void func_174959_b(@NotNull BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, @NotNull SoundEvent soundIn, @NotNull SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(@NotNull SoundEvent soundIn, @NotNull BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(@NotNull Entity entityIn) {
    }

    public void func_72709_b(@NotNull Entity entityIn) {
    }

    public void func_180440_a(int soundID, @NotNull BlockPos pos, int data) {
    }

    public void func_180439_a(@NotNull EntityPlayer player, int type, @NotNull BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, @NotNull BlockPos pos, int progress) {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)this);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        event.getWorld().func_72848_b((IWorldEventListener)this);
    }
}

