/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nonetherportals;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Mod(modid="nonetherportals", version="1.1.0", name="No Nether Portals", acceptedMinecraftVersions="[1.12.2]")
public class NoNetherPortals {
    private final Map<UUID, Long> lastMessageTimes = new HashMap<UUID, Long>();
    private static final long MESSAGE_COOLDOWN = 1200L;
    private static Configuration config;
    private static String portalMessage;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = new File(event.getModConfigurationDirectory(), "nonetherportals.cfg");
        config = new Configuration(configFile);
        this.syncConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPortalSpawnEvent(BlockEvent.PortalSpawnEvent event) {
        event.setCanceled(true);
        int range = 10;
        List players = event.getWorld().func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(event.getPos()).func_186662_g((double)range));
        long currentTime = event.getWorld().func_82737_E();
        for (EntityPlayerMP player : players) {
            long lastMessageTime;
            UUID playerId = player.func_110124_au();
            if (this.lastMessageTimes.containsKey(playerId) && currentTime - (lastMessageTime = this.lastMessageTimes.get(playerId).longValue()) < 1200L) continue;
            player.func_145747_a((ITextComponent)new TextComponentTranslation(portalMessage, new Object[0]));
            this.lastMessageTimes.put(playerId, currentTime);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.lastMessageTimes.remove(event.player.func_110124_au());
    }

    private void syncConfig() {
        config.load();
        Property propMessage = config.get("general", "portalMessage", "Portals are disabled.");
        propMessage.setComment("The message to be displayed when portals are disabled.");
        portalMessage = propMessage.getString();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandReloadConfig());
    }

    public class CommandReloadConfig
    extends CommandBase {
        @NotNull
        public String func_71517_b() {
            return "nonetherportals";
        }

        @NotNull
        public String func_71518_a(@NotNull ICommandSender sender) {
            return "/nonetherportals reload";
        }

        public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String[] args) {
            if (args.length > 0 && args[0].equals("reload")) {
                NoNetherPortals.this.syncConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString("NoNetherPortals config reloaded."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /nonetherportals reload"));
            }
        }
    }
}

