/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.network.messages;

import edgarallen.soundmuffler.SuperSoundMuffler;
import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageAddRemoveSound
implements IMessage {
    private BlockPos pos;
    private ResourceLocation sound;
    private Type type;
    private Action action;

    public MessageAddRemoveSound() {
    }

    public MessageAddRemoveSound(BlockPos pos, ResourceLocation sound, Type type, Action action) {
        this.pos = pos;
        this.sound = sound;
        this.type = type;
        this.action = action;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.sound = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.type = buf.readBoolean() ? Type.Bauble : Type.TileEntity;
        this.action = buf.readBoolean() ? Action.Add : Action.Remove;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sound.toString());
        buf.writeBoolean(this.type == Type.Bauble);
        buf.writeBoolean(this.action == Action.Add);
    }

    public static enum Type {
        Bauble,
        TileEntity;

    }

    public static enum Action {
        Add,
        Remove;

    }

    public static class Handler
    implements IMessageHandler<MessageAddRemoveSound, IMessage> {
        public IMessage onMessage(MessageAddRemoveSound message, MessageContext ctx) {
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
            if (thread.func_152345_ab()) {
                this.handle(message, ctx);
            } else {
                thread.func_152344_a(() -> this.handle(message, ctx));
            }
            return null;
        }

        private void handle(MessageAddRemoveSound message, MessageContext ctx) {
            switch (message.type) {
                case Bauble: {
                    this.handleBauble(message, ctx);
                    break;
                }
                case TileEntity: {
                    this.handleTileEntity(message, ctx);
                }
            }
        }

        private void handleBauble(MessageAddRemoveSound message, MessageContext ctx) {
            ItemStack stack;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player != null && !(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() == SuperSoundMuffler.itemSoundMufflerBauble) {
                if (message.action == Action.Add) {
                    SuperSoundMuffler.itemSoundMufflerBauble.muffleSound(stack, message.sound);
                } else {
                    SuperSoundMuffler.itemSoundMufflerBauble.unmuffleSound(stack, message.sound);
                }
            }
        }

        private void handleTileEntity(MessageAddRemoveSound message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_175625_s(message.pos);
            if (te != null && te instanceof TileEntitySoundMuffler) {
                TileEntitySoundMuffler tileEntity = (TileEntitySoundMuffler)te;
                if (message.action == Action.Add) {
                    tileEntity.muffleSound(message.sound);
                } else {
                    tileEntity.unmuffleSound(message.sound);
                }
            }
        }
    }
}

