/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.xalcon.torchmaster.TorchMasterMod;

public class EntityFilterRegistry {
    private Set<ResourceLocation> registry = new HashSet<ResourceLocation>();

    public boolean containsEntity(ResourceLocation entityName) {
        return this.registry.contains(entityName);
    }

    public void registerEntity(ResourceLocation entityName) {
        this.registry.add(entityName);
    }

    public void applyListOverrides(String[] overrides) {
        block4: for (String override : overrides) {
            if (override.length() < 4) continue;
            char prefix = override.charAt(0);
            ResourceLocation rl = new ResourceLocation(override.substring(1));
            switch (prefix) {
                case '+': {
                    if (this.containsEntity(rl)) continue block4;
                    if (EntityList.getClass((ResourceLocation)rl) == null) {
                        TorchMasterMod.Log.warn("  The entity '{}' does not exist, skipping", (Object)rl);
                        continue block4;
                    }
                    this.registerEntity(rl);
                    TorchMasterMod.Log.info("  Added '{}' to the block list", (Object)rl);
                    continue block4;
                }
                case '-': {
                    if (!this.registry.removeIf(rrl -> rrl.equals((Object)rl))) continue block4;
                    TorchMasterMod.Log.info("  Removed '{}' from the block list", (Object)rl);
                    continue block4;
                }
                default: {
                    TorchMasterMod.Log.warn("  Invalid block list prefix: '{}', only + and - are valid prefixes");
                }
            }
        }
    }

    public ResourceLocation[] getRegisteredEntities() {
        return this.registry.toArray(new ResourceLocation[0]);
    }
}

