/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.xalcon.torchmaster.common.blocks.BlockBase;
import net.xalcon.torchmaster.common.blocks.BlockDreadLamp;
import net.xalcon.torchmaster.common.blocks.BlockFeralFlareLantern;
import net.xalcon.torchmaster.common.blocks.BlockInvisibleLight;
import net.xalcon.torchmaster.common.blocks.BlockMegaTorch;
import net.xalcon.torchmaster.common.blocks.BlockTerrainLighter;
import net.xalcon.torchmaster.common.tiles.IAutoRegisterTileEntity;

@GameRegistry.ObjectHolder(value="torchmaster")
@Mod.EventBusSubscriber
public class ModBlocks {
    @GameRegistry.ObjectHolder(value="mega_torch")
    private static final BlockMegaTorch MegaTorch = null;
    @GameRegistry.ObjectHolder(value="terrain_lighter")
    private static final BlockTerrainLighter TerrainLighter = null;
    @GameRegistry.ObjectHolder(value="dread_lamp")
    private static final BlockDreadLamp DreadLamp = null;
    @GameRegistry.ObjectHolder(value="feral_flare_lantern")
    private static final BlockFeralFlareLantern FeralFlareLantern = null;
    @GameRegistry.ObjectHolder(value="invisible_light")
    private static final BlockInvisibleLight InvisibleLight = null;

    public static BlockMegaTorch getMegaTorch() {
        return MegaTorch;
    }

    public static BlockTerrainLighter getTerrainLighter() {
        return TerrainLighter;
    }

    public static BlockDreadLamp getDreadLamp() {
        return DreadLamp;
    }

    public static BlockInvisibleLight getInvisibleLight() {
        return InvisibleLight;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blocks = new Block[]{new BlockMegaTorch(), new BlockTerrainLighter(), new BlockDreadLamp(), new BlockFeralFlareLantern(), new BlockInvisibleLight()};
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
        Arrays.stream(blocks).filter(block -> block instanceof IAutoRegisterTileEntity).map(block -> (IAutoRegisterTileEntity)block).forEach(block -> GameRegistry.registerTileEntity(block.getTileEntityClass(), (String)block.getTileEntityRegistryName()));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BlockBase[] blocks = new BlockBase[]{MegaTorch, TerrainLighter, DreadLamp, FeralFlareLantern};
        event.getRegistry().registerAll((IForgeRegistryEntry[])Arrays.stream(blocks).map(BlockBase::createItemBlock).filter(Objects::nonNull).toArray(Item[]::new));
    }

    @SubscribeEvent
    public static void registerItems(ModelRegistryEvent event) {
        BlockBase[] blocks = new BlockBase[]{MegaTorch, TerrainLighter, DreadLamp, FeralFlareLantern};
        Arrays.stream(blocks).forEach(block -> block.registerItemModels(Item.func_150898_a((Block)block)));
    }
}

