/*
 * Decompiled with CFR 0.152.
 */
package portb.mod.uberconduitprobe.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RendererHelper {
    private static final Cache<Tuple<BlockPos, BlockPos>, Integer> cacheOverlay = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(1L, TimeUnit.SECONDS).removalListener(removal -> GLAllocation.func_74523_b((int)((Integer)removal.getValue()))).build();

    public static void renderSelectedAreaOverlay(RenderWorldLastEvent event, EntityPlayer player, BlockPos firstPos, BlockPos secondPos, byte red, byte blue, byte green) {
        GlStateManager.func_179094_E();
        double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        try {
            GlStateManager.func_179148_o((int)((Integer)cacheOverlay.get((Object)new Tuple((Object)firstPos, (Object)secondPos), () -> {
                int displayList = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)displayList, (int)4864);
                RendererHelper.render(player, player.field_70170_p, firstPos, secondPos, red, blue, green);
                GlStateManager.func_187415_K();
                return displayList;
            })));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private static void render(EntityPlayer player, World world, BlockPos start, BlockPos end, byte red, byte blue, byte green) {
        int x = Math.min(start.func_177958_n(), end.func_177958_n());
        int y = Math.min(start.func_177956_o(), end.func_177956_o());
        int z = Math.min(start.func_177952_p(), end.func_177952_p());
        int distanceX = Math.max(start.func_177958_n() + 1, end.func_177958_n() + 1);
        int distanceY = Math.max(start.func_177956_o() + 1, end.func_177956_o() + 1);
        int distanceZ = Math.max(start.func_177952_p() + 1, end.func_177952_p() + 1);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RendererHelper.renderSolidBox(tessellator, (double)x - 0.006, (double)y - 0.006, (double)z - 0.006, (double)distanceX + 0.006, (double)distanceY + 0.006, (double)distanceZ + 0.006, (float)red / 255.0f, (float)blue / 255.0f, (float)green / 255.0f, 0.5f);
        RendererHelper.renderBox(tessellator, (double)x - 0.0011, (double)y - 0.0011, (double)z - 0.0011, (double)distanceX + 0.0011, (double)distanceY + 0.0011, (double)distanceZ + 0.0011, (float)red / 255.0f, (float)blue / 255.0f, (float)green / 255.0f, 0.75f);
        GlStateManager.func_179112_b((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void renderBox(Tessellator tessellator, double startX, double startY, double startZ, double endX, double endY, double endZ, float red, float green, float blue, float alpha) {
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_187441_d((float)2.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
    }

    private static void renderSolidBox(Tessellator tessellator, double startX, double startY, double startZ, double endX, double endY, double endZ, float red, float green, float blue, float alpha) {
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    private static Comparator<BlockPos> getRelativePosComparator(Vec3d playerPos) {
        return (o1, o2) -> {
            double bDist;
            Vec3d a = new Vec3d((double)o1.func_177958_n(), (double)o1.func_177956_o(), (double)o1.func_177952_p());
            Vec3d b = new Vec3d((double)o2.func_177958_n(), (double)o2.func_177956_o(), (double)o2.func_177952_p());
            double aDist = a.func_72438_d(playerPos);
            if (aDist < (bDist = b.func_72438_d(playerPos))) {
                return -1;
            }
            if (aDist == bDist) {
                return 0;
            }
            if (aDist > bDist) {
                return 1;
            }
            throw new RuntimeException("This should never occur");
        };
    }

    private static void renderMyOverlay(EntityPlayer player, World world, BlockPos start, BlockPos end, byte red, byte blue, byte green) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RendererHelper.renderBlockRangeOverlay(start, end, red, blue, green);
        GlStateManager.func_179112_b((int)770, (int)771);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)MinecraftForgeClient.getRenderLayer());
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void renderBlockRangeOverlay(BlockPos start, BlockPos finish, byte red, byte blue, byte green) {
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)start.func_177958_n(), (float)start.func_177956_o(), (float)start.func_177952_p());
        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.005f, (float)-0.005f, (float)-0.005f);
        GlStateManager.func_179152_a((float)((float)(finish.func_177958_n() - start.func_177958_n()) + 0.01f), (float)((float)(finish.func_177956_o() - start.func_177956_o()) + 0.01f), (float)((float)(finish.func_177952_p() - start.func_177952_p()) + 0.01f));
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        RendererHelper.renderSolidBox(tessellator, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, (float)red / 255.0f, (float)blue / 255.0f, (float)green / 255.0f, 0.5f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private static void renderBlockPosOverlay(BlockPos pos, byte red, byte green, byte blue) {
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.005f, (float)-0.005f, (float)0.005f);
        GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        RendererHelper.renderSolidBox(tessellator, 0.0, 0.0, -1.0, 1.0, 1.0, 0.0, (float)red / 255.0f, (float)blue / 255.0f, (float)green / 255.0f, 0.5f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private static Set<BlockPos> makeSetForBlockPosRange(BlockPos start, BlockPos end) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = Math.min(start.func_177958_n(), end.func_177958_n()); x <= Math.max(start.func_177958_n(), end.func_177958_n()); ++x) {
            for (int y = Math.min(start.func_177956_o(), end.func_177956_o()); y <= Math.max(start.func_177956_o(), end.func_177956_o()); ++y) {
                for (int z = Math.min(start.func_177952_p(), end.func_177952_p()); z <= Math.max(start.func_177952_p(), end.func_177952_p()); ++z) {
                    posList.add(new BlockPos(x, y, z));
                }
            }
        }
        return new HashSet<BlockPos>(posList);
    }
}

