/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.dynamicresources.ICachedResourcePack;
import org.embeddedt.vintagefix.dynamicresources.helpers.DefaultPackAdapter;
import org.embeddedt.vintagefix.dynamicresources.helpers.FilePackAdapter;
import org.embeddedt.vintagefix.dynamicresources.helpers.FolderPackAdapter;
import org.embeddedt.vintagefix.dynamicresources.helpers.RemappingAdapter;

public class ResourcePackHelper {
    private static final Map<Class<? extends IResourcePack>, Adapter<? extends IResourcePack>> ADAPTERS = new Object2ObjectArrayMap();
    public static final Pattern PATH_TO_RESLOC_REGEX;
    public static final Pattern PATH_TO_SHORT_RESLOC_REGEX;

    public static <T extends IResourcePack> void registerAdapter(Class<T> clz, Adapter<T> adapter) {
        ADAPTERS.put(clz, adapter);
    }

    public static Collection<IResourcePack> getAllPacks(SimpleReloadableResourceManager manager) {
        LinkedHashSet<IResourcePack> resourcePacks = new LinkedHashSet<IResourcePack>();
        Map domainManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)manager, (String)"field_110548_a");
        for (FallbackResourceManager fallback : domainManagers.values()) {
            List fallbackPacks = (List)ObfuscationReflectionHelper.getPrivateValue(FallbackResourceManager.class, (Object)fallback, (String)"field_110540_a");
            resourcePacks.addAll(fallbackPacks);
        }
        return resourcePacks;
    }

    public static Collection<String> getAllPaths(SimpleReloadableResourceManager manager, Predicate<String> filter) {
        Collection<IResourcePack> resourcePacks = ResourcePackHelper.getAllPacks(manager);
        ObjectOpenHashSet paths = new ObjectOpenHashSet();
        for (IResourcePack pack : resourcePacks) {
            try {
                paths.addAll(ResourcePackHelper.getAllPaths(pack, filter));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return paths;
    }

    private static <T extends IResourcePack> Collection<String> applyAdapter(IResourcePack pack, Predicate<String> filter, Adapter<T> adapter) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        Iterator<String> incomingPaths = adapter.getAllPaths(pack, filter);
        while (incomingPaths.hasNext()) {
            paths.add(incomingPaths.next());
        }
        return paths;
    }

    public static Collection<String> getAllPaths(IResourcePack pack, Predicate<String> filter) throws IOException {
        ICachedResourcePack cachePack;
        Stream<String> paths;
        if (pack instanceof ICachedResourcePack && (paths = (cachePack = (ICachedResourcePack)pack).getAllPaths()) != null) {
            return paths.filter(filter).collect(Collectors.toList());
        }
        for (Map.Entry<Class<? extends IResourcePack>, Adapter<? extends IResourcePack>> adapterEntry : ADAPTERS.entrySet()) {
            if (!adapterEntry.getKey().isAssignableFrom(pack.getClass())) continue;
            return ResourcePackHelper.applyAdapter(pack, filter, adapterEntry.getValue());
        }
        VintageFix.LOGGER.warn("Cannot list resources from pack {} ({})", (Object)pack.func_130077_b(), (Object)pack.getClass().getName());
        return ImmutableList.of();
    }

    public static ResourceLocation pathToResourceLocation(String path, ResourceLocationMatchType type) {
        Pattern pattern;
        switch (type) {
            default: {
                pattern = PATH_TO_SHORT_RESLOC_REGEX;
                break;
            }
            case FULL: {
                pattern = PATH_TO_RESLOC_REGEX;
            }
        }
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            return new ResourceLocation(matcher.group(1), matcher.group(2));
        }
        return null;
    }

    static {
        ResourcePackHelper.registerAdapter(LegacyV2Adapter.class, new RemappingAdapter<LegacyV2Adapter>(pack -> (IResourcePack)ObfuscationReflectionHelper.getPrivateValue(LegacyV2Adapter.class, (Object)pack, (String)"field_191383_a")));
        ResourcePackHelper.registerAdapter(DefaultResourcePack.class, new DefaultPackAdapter());
        ResourcePackHelper.registerAdapter(FileResourcePack.class, new FilePackAdapter());
        ResourcePackHelper.registerAdapter(FolderResourcePack.class, new FolderPackAdapter());
        PATH_TO_RESLOC_REGEX = Pattern.compile("^/?assets/(.+?(?=/))/(.*)$");
        PATH_TO_SHORT_RESLOC_REGEX = Pattern.compile("^^/?assets/(.+?(?=/))/(?:.+?(?=/))/(.*)\\.(?:[A-Za-z]*)$");
    }

    @FunctionalInterface
    public static interface Adapter<T extends IResourcePack> {
        public Iterator<String> getAllPaths(T var1, Predicate<String> var2) throws IOException;
    }

    public static enum ResourceLocationMatchType {
        SHORT,
        FULL;

    }
}

