/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicBakedModelProvider;
import org.embeddedt.vintagefix.event.DynamicModelBakeEvent;

public class SafeModelBakeWrapper {
    public static ModelManager theManager;
    private static final ImmutableList<Pair<String, String>> MOD_BAKE_CLASSES;

    public static void setup() {
        for (Pair pair : MOD_BAKE_CLASSES) {
            try {
                Class<?> clz;
                try {
                    clz = Class.forName((String)pair.getLeft());
                }
                catch (ClassNotFoundException | LinkageError ignored) {
                    continue;
                }
                Method theMethod = clz.getDeclaredMethod((String)pair.getRight(), ModelBakeEvent.class);
                if (!Modifier.isStatic(theMethod.getModifiers())) {
                    VintageFix.LOGGER.warn("Non-static methods currently not supported (on {})", (Object)pair);
                    continue;
                }
                theMethod.setAccessible(true);
                MethodHandle eventHook = MethodHandles.lookup().unreflect(theMethod);
                MinecraftForge.EVENT_BUS.register((Object)new WrappingHandler(eventHook));
                VintageFix.LOGGER.info("Registered model bake compat for {}", pair.getLeft());
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                VintageFix.LOGGER.error("Failed to setup model bake wrapper for {}", (Object)pair);
            }
        }
    }

    static {
        MOD_BAKE_CLASSES = ImmutableList.builder().add((Object)Pair.of((Object)"tschipp.hardcoreitemstages.ItemStageEventHandler", (Object)"onModelBakeEvent")).build();
    }

    public static class WrappingHandler {
        private final MethodHandle modEventHandler;
        private int recursion = 0;

        WrappingHandler(MethodHandle modEventHandler) {
            this.modEventHandler = modEventHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onDynBake(DynamicModelBakeEvent e) {
            if (!(e.location instanceof ModelResourceLocation) || this.recursion > 0 || theManager == null) {
                return;
            }
            ++this.recursion;
            try {
                RegistrySimple reg = new RegistrySimple();
                reg.func_82595_a((Object)((ModelResourceLocation)e.location), (Object)e.bakedModel);
                ModelBakeEvent event = new ModelBakeEvent(theManager, (IRegistry)reg, null);
                try {
                    this.modEventHandler.invokeExact(event);
                }
                catch (Throwable ex) {
                    VintageFix.LOGGER.error("Exception running mod event handler", ex);
                }
                if (reg.func_148742_b().size() == 1) {
                    IBakedModel m = (IBakedModel)reg.func_82594_a((Object)((ModelResourceLocation)e.location));
                    if (m != null) {
                        e.bakedModel = m;
                    }
                } else {
                    for (ModelResourceLocation key : reg.func_148742_b()) {
                        IBakedModel m = (IBakedModel)reg.func_82594_a((Object)key);
                        if (m == null) continue;
                        if (Objects.equals(key, e.location)) {
                            e.bakedModel = m;
                            continue;
                        }
                        DynamicBakedModelProvider.instance.putObject(key, m);
                    }
                }
            }
            finally {
                --this.recursion;
            }
        }
    }
}

