/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;

public class StateMapperHandler {
    private final LoadingCache<Block, Map<IBlockState, ModelResourceLocation>> modelLocationCache;

    public StateMapperHandler(final BlockStateMapper blockStateMapper) {
        this.modelLocationCache = CacheBuilder.newBuilder().maximumWeight(100000L).weigher((key, value) -> value.size()).build((CacheLoader)new CacheLoader<Block, Map<IBlockState, ModelResourceLocation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<IBlockState, ModelResourceLocation> load(Block key) throws Exception {
                BlockStateMapper blockStateMapper2 = blockStateMapper;
                synchronized (blockStateMapper2) {
                    return ImmutableMap.copyOf((Map)blockStateMapper.func_188181_b(key));
                }
            }
        });
    }

    public ModelResourceLocation getModelLocationForState(IBlockState state) {
        try {
            return (ModelResourceLocation)((Map)this.modelLocationCache.get((Object)state.func_177230_c())).get(state);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

