/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.fastmap;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.properties.IProperty;

public class FakeStateMap<S>
implements Map<Map<IProperty<?>, Comparable<?>>, S> {
    private final Map<IProperty<?>, Comparable<?>>[] keys;
    private final Object[] values;
    private int usedSlots;

    public FakeStateMap(int numStates) {
        this.keys = new Map[numStates];
        this.values = new Object[numStates];
        this.usedSlots = 0;
    }

    @Override
    public int size() {
        return this.usedSlots;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public S get(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public S put(Map<IProperty<?>, Comparable<?>> propertyComparableMap, S s) {
        this.keys[this.usedSlots] = propertyComparableMap;
        this.values[this.usedSlots] = s;
        ++this.usedSlots;
        return null;
    }

    @Override
    public S remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Map<IProperty<?>, Comparable<?>>, ? extends S> map) {
        for (Map.Entry<Map<IProperty<?>, Comparable<?>>, S> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.usedSlots = 0;
    }

    @Override
    public Set<Map<IProperty<?>, Comparable<?>>> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<S> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Map<IProperty<?>, Comparable<?>>, S>> entrySet() {
        return new Set<Map.Entry<Map<IProperty<?>, Comparable<?>>, S>>(){

            @Override
            public int size() {
                return FakeStateMap.this.usedSlots;
            }

            @Override
            public boolean isEmpty() {
                return FakeStateMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<Map<IProperty<?>, Comparable<?>>, S>> iterator() {
                return new Iterator<Map.Entry<Map<IProperty<?>, Comparable<?>>, S>>(){
                    int currentIdx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.currentIdx < FakeStateMap.this.usedSlots;
                    }

                    @Override
                    public Map.Entry<Map<IProperty<?>, Comparable<?>>, S> next() {
                        if (this.currentIdx >= FakeStateMap.this.usedSlots) {
                            throw new IndexOutOfBoundsException();
                        }
                        AbstractMap.SimpleImmutableEntry<Map, Object> entry = new AbstractMap.SimpleImmutableEntry<Map, Object>(FakeStateMap.this.keys[this.currentIdx], FakeStateMap.this.values[this.currentIdx]);
                        ++this.currentIdx;
                        return entry;
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] ts) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Map.Entry<Map<IProperty<?>, Comparable<?>>, S> mapSEntry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Map<IProperty<?>, Comparable<?>>, S>> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

