/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.impl;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.vintagefix.impl.Deduplicator;
import org.embeddedt.vintagefix.util.PredicateHelper;

public class KeyValueConditionImpl {
    private static final Map<Pair<IProperty<?>, Comparable<?>>, Predicate<IBlockState>> STATE_HAS_PROPERTY_CACHE = new ConcurrentHashMap();

    public static Predicate<IBlockState> getPredicate(BlockStateContainer stateContainer, String key, String value, Splitter splitter) {
        Predicate<IBlockState> isMatchedState;
        List matchedStates;
        boolean invert;
        IProperty property = stateContainer.func_185920_a(key);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s' on '%s'", key, stateContainer.func_177622_c().toString()));
        }
        String valueNoInvert = value;
        boolean bl = invert = !valueNoInvert.isEmpty() && valueNoInvert.charAt(0) == '!';
        if (invert) {
            valueNoInvert = valueNoInvert.substring(1);
        }
        if ((matchedStates = splitter.splitToList((CharSequence)valueNoInvert)).isEmpty()) {
            throw new RuntimeException(String.format("Empty value '%s' for property '%s' on '%s'", value, key, stateContainer.func_177622_c().toString()));
        }
        if (matchedStates.size() == 1) {
            isMatchedState = KeyValueConditionImpl.getBlockStatePredicate(stateContainer, property, valueNoInvert, key, value);
        } else {
            List subPredicates = matchedStates.stream().map(subValue -> KeyValueConditionImpl.getBlockStatePredicate(stateContainer, property, subValue, key, value)).collect(Collectors.toCollection(ArrayList::new));
            PredicateHelper.canonize(subPredicates);
            isMatchedState = Deduplicator.or(subPredicates);
        }
        return invert ? s -> !isMatchedState.test(s) : isMatchedState;
    }

    private static <T extends Comparable<T>> Predicate<IBlockState> getBlockStatePredicate(BlockStateContainer container, IProperty<T> property, String subValue, String key, String value) {
        Optional optional = property.func_185929_b(subValue);
        if (!optional.isPresent()) {
            throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s' in '%s'", subValue, key, container.func_177622_c().toString(), value));
        }
        Comparable unwrapped = (Comparable)optional.get();
        return STATE_HAS_PROPERTY_CACHE.computeIfAbsent(Pair.of(property, (Object)unwrapped), pair -> {
            Comparable valueInt = (Comparable)pair.getRight();
            IProperty propInt = (IProperty)pair.getLeft();
            return state -> state.func_177229_b(propInt).equals(valueInt);
        });
    }
}

