/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.impl;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import org.embeddedt.vintagefix.core.VintageFixCore;

public class ModelSidesImpl {
    private static final EnumFacing[] SIDES = EnumFacing.values();
    private static final Map<EnumFacing, List<BakedQuad>> EMPTY;

    private static <T> List<T> safeImmutableList(List<T> quadList) {
        return VintageFixCore.OPTIFINE ? quadList : ImmutableList.copyOf(quadList);
    }

    public static List<BakedQuad> minimizeUnculled(List<BakedQuad> quads) {
        return ModelSidesImpl.safeImmutableList(quads);
    }

    public static Map<EnumFacing, List<BakedQuad>> minimizeCulled(Map<EnumFacing, List<BakedQuad>> quadsBySide) {
        if (quadsBySide.isEmpty()) {
            return quadsBySide;
        }
        boolean allEmpty = true;
        for (EnumFacing face : SIDES) {
            List<BakedQuad> sideQuads = quadsBySide.get(face);
            try {
                quadsBySide.put(face, ModelSidesImpl.safeImmutableList(sideQuads));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            allEmpty &= sideQuads.isEmpty();
        }
        return allEmpty ? EMPTY : quadsBySide;
    }

    static {
        EnumMap<EnumFacing, List<BakedQuad>> map = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        for (EnumFacing side : SIDES) {
            map.put(side, (List<BakedQuad>)ImmutableList.of());
        }
        EMPTY = map;
    }
}

