/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.dynamicresources.IExtendedModelLoader;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(targets={"net/minecraftforge/client/model/ModelLoader$VariantLoader"})
@ClientOnlyMixin
public class MixinVariantLoader {
    @Shadow
    private ModelLoader loader;
    private static final MethodHandle WEIGHTED_CONSTRUCTOR;
    private static final MethodHandle MULTIPART_CONSTRUCTOR;

    private VariantList normalizeAndGetVariant(ModelBlockDefinition definition, String variant) {
        if (definition.func_188000_b(variant)) {
            return definition.func_188004_c(variant);
        }
        if (variant.equals("normal") && definition.func_188000_b("")) {
            return definition.func_188004_c("");
        }
        return null;
    }

    @Overwrite(remap=false)
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        ResourceLocation baseLocation;
        ModelResourceLocation variant = (ModelResourceLocation)modelLocation;
        ModelBlockDefinition definition = ((IExtendedModelLoader)this.loader).vfix$getModelBlockDef((ResourceLocation)variant);
        VariantList vList = this.normalizeAndGetVariant(definition, variant.func_177518_c());
        if (vList != null) {
            try {
                return WEIGHTED_CONSTRUCTOR.invoke(variant, vList);
            }
            catch (Throwable e) {
                throw (Exception)e;
            }
        }
        if (definition.func_188002_b() && !ModelLocationInformation.isAppropriateMultipart(baseLocation = new ResourceLocation(variant.func_110624_b(), variant.func_110623_a()), variant)) {
            throw new Exception("Not valid multipart for " + definition.func_188001_c().func_188135_c() + ": " + variant);
        }
        try {
            return MULTIPART_CONSTRUCTOR.invoke(new ResourceLocation(variant.func_110624_b(), variant.func_110623_a()), definition.func_188001_c());
        }
        catch (Throwable e) {
            throw (Exception)e;
        }
    }

    static {
        MethodHandle multipart;
        MethodHandle variant;
        try {
            Class<?> weightedModel = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedRandomModel");
            Class<?> multipartModel = Class.forName("net.minecraftforge.client.model.ModelLoader$MultipartModel");
            Constructor<?> weightedC = weightedModel.getConstructor(ResourceLocation.class, VariantList.class);
            Constructor<?> multipartC = multipartModel.getConstructor(ResourceLocation.class, Multipart.class);
            variant = MethodHandles.lookup().unreflectConstructor(weightedC);
            multipart = MethodHandles.lookup().unreflectConstructor(multipartC);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            variant = null;
            multipart = null;
        }
        WEIGHTED_CONSTRUCTOR = variant;
        MULTIPART_CONSTRUCTOR = multipart;
    }
}

