/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixinextras.sugar.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.embeddedt.vintagefix.mixinextras.lib.apache.commons.tuple.Pair;
import org.embeddedt.vintagefix.mixinextras.sugar.SugarBridge;
import org.embeddedt.vintagefix.mixinextras.sugar.impl.SugarApplicationException;
import org.embeddedt.vintagefix.mixinextras.sugar.impl.SugarInjector;
import org.embeddedt.vintagefix.mixinextras.sugar.impl.handlers.HandlerInfo;
import org.embeddedt.vintagefix.mixinextras.utils.CompatibilityHelper;
import org.embeddedt.vintagefix.mixinextras.utils.GenericParamParser;
import org.embeddedt.vintagefix.mixinextras.utils.MixinInternals;
import org.embeddedt.vintagefix.mixinextras.wrapper.InjectorWrapperImpl;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.asm.MethodNodeEx;

public class SugarWrapperImpl
extends InjectorWrapperImpl {
    private final InjectionInfo wrapperInfo;
    private final AnnotationNode originalAnnotation;
    private final List<AnnotationNode> sugarAnnotations;
    private final ArrayList<Type> generics;
    private final MethodNode handler;
    private final InjectionInfo delegate;
    private final SugarInjector sugarInjector;

    protected SugarWrapperImpl(InjectionInfo wrapper, MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(wrapper, mixin, method, annotation, true);
        this.wrapperInfo = wrapper;
        method.visibleAnnotations.remove(annotation);
        this.originalAnnotation = (AnnotationNode)Annotations.getValue((AnnotationNode)annotation, (String)"original");
        method.visibleAnnotations.add(this.originalAnnotation);
        this.sugarAnnotations = (List)Annotations.getValue((AnnotationNode)annotation, (String)"sugars");
        this.generics = new ArrayList<Type>(GenericParamParser.getParameterGenerics(method.desc, (String)Annotations.getValue((AnnotationNode)annotation, (String)"signature")));
        this.handler = this.prepareHandler(method);
        this.sugarInjector = new SugarInjector(this.wrapperInfo, mixin.getMixin(), this.handler, this.sugarAnnotations, this.generics);
        this.sugarInjector.stripSugar();
        this.delegate = InjectionInfo.parse((MixinTargetContext)mixin, (MethodNode)this.handler);
        this.sugarInjector.setTargets(MixinInternals.getTargets(this.delegate));
        if (!this.isValid()) {
            this.sugarInjector.reSugarHandler();
        }
    }

    @Override
    protected InjectionInfo getDelegate() {
        return this.delegate;
    }

    @Override
    protected MethodNode getHandler() {
        return this.handler;
    }

    @Override
    protected void prepare() {
        super.prepare();
        this.sugarInjector.prepareSugar();
    }

    @Override
    protected void granularInject(InjectorWrapperImpl.HandlerCallCallback callback) {
        HashMap<Target, List<Pair<InjectionNodes.InjectionNode, MethodInsnNode>>> handlerCallMap = new HashMap<Target, List<Pair<InjectionNodes.InjectionNode, MethodInsnNode>>>();
        super.granularInject((target, sourceNode, call) -> {
            callback.onFound(target, sourceNode, call);
            handlerCallMap.computeIfAbsent(target, k -> new ArrayList()).add(Pair.of(sourceNode, call));
        });
        this.sugarInjector.reSugarHandler();
        this.sugarInjector.transformHandlerCalls(handlerCallMap);
    }

    @Override
    protected void doPostInject(Runnable postInject) {
        try {
            super.doPostInject(postInject);
        }
        catch (InjectionError | InvalidInjectionException e) {
            for (SugarApplicationException sugarException : this.sugarInjector.getExceptions()) {
                e.addSuppressed((Throwable)((Object)sugarException));
            }
            throw e;
        }
    }

    private MethodNode prepareHandler(MethodNode original) {
        IMixinInfo mixin = CompatibilityHelper.getMixin(this.wrapperInfo).getMixin();
        HandlerInfo handlerInfo = SugarInjector.getHandlerInfo(mixin, original, this.sugarAnnotations, this.generics);
        if (handlerInfo == null) {
            return original;
        }
        MethodNodeEx newMethod = new MethodNodeEx(original.access, MethodNodeEx.getName((MethodNode)original), original.desc, original.signature, original.exceptions.toArray(new String[0]), mixin);
        original.accept((MethodVisitor)newMethod);
        original.visibleAnnotations.remove(this.originalAnnotation);
        newMethod.name = original.name;
        newMethod.tryCatchBlocks = null;
        newMethod.visitAnnotation(Type.getDescriptor(SugarBridge.class), false);
        handlerInfo.transformHandler(this.classNode, (MethodNode)newMethod);
        handlerInfo.transformGenerics(this.generics);
        this.classNode.methods.add(newMethod);
        return newMethod;
    }
}

