/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores;

import hellfall.visualores.proxy.ICommonProxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="visualores", version="0.2.6", name="VisualOres", acceptedMinecraftVersions="[1.12.2]", dependencies="after:gregtech@[2.8.0-beta,);required:mixinbooter;required-after:codechickenlib@[${mod_version},);")
public class VisualOres {
    public static final Logger LOGGER = LogManager.getLogger((String)"visualores");
    @SidedProxy(modId="visualores", clientSide="hellfall.visualores.proxy.VOClientProxy", serverSide="hellfall.visualores.proxy.VOCommonProxy")
    public static ICommonProxy voProxy;
    private static final List<ICommonProxy> proxies;
    private static final Set<String> modsRequiringServer;
    private static boolean clientOnlyMode;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxies.add(voProxy);
        VisualOres.addModRequiringServer("gregtech");
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.preInit(event);
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.init(event);
        }
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.postInit(event);
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.serverStarting(event);
        }
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.serverStopped(event);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        for (ICommonProxy proxy : proxies) {
            proxy.worldLoad(event);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        for (ICommonProxy proxy : proxies) {
            proxy.worldUnload(event);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        for (ICommonProxy proxy : proxies) {
            proxy.worldSave(event);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.entityJoinWorld(event);
        }
    }

    @SubscribeEvent
    public void onConfigSave(ConfigChangedEvent.OnConfigChangedEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.syncConfig(event);
        }
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.onKeyPress(event);
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        for (ICommonProxy proxy : proxies) {
            proxy.onClientDisconnect(event);
        }
    }

    @NetworkCheckHandler
    public boolean checkModVersions(Map<String, String> mods, Side side) {
        boolean containsSameVOVersion;
        boolean containsVO = mods.containsKey("visualores");
        boolean bl = containsSameVOVersion = containsVO && mods.get("visualores").equals("0.2.6");
        if (side == Side.CLIENT) {
            return containsSameVOVersion;
        }
        clientOnlyMode = !containsVO;
        for (String modid : modsRequiringServer) {
            if (!mods.containsKey(modid) || containsVO) continue;
            LOGGER.error("Could not connect to server! Server does not have visualores but it is required when " + modid + " is loaded!");
            return false;
        }
        return !containsVO || containsSameVOVersion;
    }

    public static void addModRequiringServer(String modid) {
        modsRequiringServer.add(modid);
    }

    public static boolean isClientOnlyMode() {
        return clientOnlyMode;
    }

    static {
        proxies = new ArrayList<ICommonProxy>();
        modsRequiringServer = new HashSet<String>();
        clientOnlyMode = false;
    }
}

