/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.astralsorcery;

import hellfall.visualores.database.IClientCachePerDimOnly;
import hellfall.visualores.database.astralsorcery.ASDimensionCache;
import hellfall.visualores.database.astralsorcery.NeromanticPosition;
import hellfall.visualores.database.astralsorcery.StarfieldPosition;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fluids.Fluid;

public class ASClientCache
implements IClientCachePerDimOnly {
    public static final ASClientCache instance = new ASClientCache();
    private final Int2ObjectMap<ASDimensionCache> cache = new Int2ObjectArrayMap();

    public void addStarfields() {
        int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new ASDimensionCache());
        }
        ((ASDimensionCache)this.cache.get(dim)).addStarfields();
    }

    public List<StarfieldPosition> getStarfieldsInBounds(int dim, int[] bounds) {
        if (this.cache.containsKey(dim)) {
            return ((ASDimensionCache)this.cache.get(dim)).getStarfieldsInArea(new ChunkPos(bounds[0] >> 4, bounds[1] >> 4), new ChunkPos(bounds[0] + bounds[2] >> 4, bounds[1] + bounds[3] >> 4));
        }
        return new ArrayList<StarfieldPosition>();
    }

    public void setNeromanticFluid(int dim, ChunkPos pos, Fluid fluid) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new ASDimensionCache());
        }
        ((ASDimensionCache)this.cache.get(dim)).setNeromanticFluid(pos, fluid);
    }

    public List<NeromanticPosition> getNeromanticVeinsInBounds(int dim, int[] bounds) {
        if (this.cache.containsKey(dim)) {
            return ((ASDimensionCache)this.cache.get(dim)).getNeromanticVeinsInArea(new ChunkPos(bounds[0] >> 4, bounds[1] >> 4), new ChunkPos(bounds[0] + bounds[2] >> 4, bounds[1] + bounds[3] >> 4));
        }
        return new ArrayList<NeromanticPosition>();
    }

    @Override
    public void setupCacheFiles() {
        this.addDimFiles("starfields_");
        this.addDimFiles("neromantic_");
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Collection<Integer> getExistingDimensions(String prefix) {
        return this.cache.keySet();
    }

    @Override
    public NBTTagCompound saveDimFile(String prefix, int dim) {
        if (this.cache.containsKey(dim)) {
            return ((ASDimensionCache)this.cache.get(dim)).toNBT(prefix);
        }
        return null;
    }

    @Override
    public void readDimFile(String prefix, int dim, NBTTagCompound data) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new ASDimensionCache());
        }
        ((ASDimensionCache)this.cache.get(dim)).fromNBT(prefix, data);
    }
}

