/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.astralsorcery;

import hellfall.visualores.map.DrawUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class NeromanticPosition {
    public int x;
    public int z;
    public int color;
    public String fluid;
    public List<String> tooltip;

    public NeromanticPosition(ChunkPos pos, Fluid fluid) {
        this.x = pos.field_77276_a;
        this.z = pos.field_77275_b;
        this.color = DrawUtils.getFluidColor(fluid);
        this.fluid = fluid.getName();
        this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"visualores.astralsorcery.fluid", (Object[])new Object[]{fluid.getLocalizedName(null)}));
    }

    public NeromanticPosition(String fluid, int x, int z) {
        this.x = x;
        this.z = z;
        this.fluid = fluid;
        Fluid f = FluidRegistry.getFluid((String)fluid);
        this.color = DrawUtils.getFluidColor(f);
        this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"visualores.astralsorcery.fluid", (Object[])new Object[]{f.getLocalizedName(null)}));
    }

    public NBTTagString toNBT() {
        return new NBTTagString(this.fluid);
    }
}

