/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.astralsorcery;

import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class StarfieldPosition {
    public int x;
    public int z;
    public final boolean[] low = new boolean[256];
    public final boolean[] high = new boolean[256];

    public StarfieldPosition(ChunkPos chunk) {
        this.x = chunk.field_77276_a;
        this.z = chunk.field_77275_b;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos origin = chunk.func_180331_a(0, 0, 0);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.func_181079_c(origin.func_177958_n() + x, 0, origin.func_177952_p() + z);
                float amt = ((Float)SkyCollectionHelper.getSkyNoiseDistributionClient((World)world, (BlockPos)pos).get()).floatValue();
                if (amt >= 0.8f) {
                    this.high[x * 16 + z] = true;
                    continue;
                }
                if (!(amt >= 0.4f)) continue;
                this.low[x * 16 + z] = true;
            }
        }
    }

    public StarfieldPosition(NBTTagCompound nbt, int x, int z) {
        int i;
        this.x = x;
        this.z = z;
        if (nbt.func_74764_b("low")) {
            int[] lowi = nbt.func_74759_k("low");
            for (i = 0; i < 256; ++i) {
                this.low[i] = (lowi[i / 32] >> i % 32 & 1) == 1;
            }
        }
        if (nbt.func_74764_b("high")) {
            int[] highi = nbt.func_74759_k("high");
            for (i = 0; i < 256; ++i) {
                this.high[i] = (highi[i / 32] >> i % 32 & 1) == 1;
            }
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = new NBTTagCompound();
        boolean lowEmpty = true;
        boolean highEmpty = true;
        int[] lowi = new int[8];
        int[] highi = new int[8];
        for (int i = 0; i < 256; ++i) {
            if (this.low[i]) {
                int n = i / 32;
                lowi[n] = lowi[n] | 1 << i % 32;
                lowEmpty = false;
            }
            if (!this.high[i]) continue;
            int n = i / 32;
            highi[n] = highi[n] | 1 << i % 32;
            highEmpty = false;
        }
        if (!lowEmpty) {
            result.func_74783_a("low", lowi);
        }
        if (!highEmpty) {
            result.func_74783_a("high", highi);
        }
        return result;
    }
}

