/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.fluid;

import gregtech.api.worldgen.bedrockFluids.ChunkPosDimension;
import hellfall.visualores.map.DrawUtils;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class UndergroundFluidPosition {
    public ChunkPosDimension pos;
    public String fluid;
    public int yield;
    public double percent;
    public String name;
    public int color;

    public UndergroundFluidPosition(int dim, int fieldX, int fieldZ, String fluid, int yield, double percent) {
        this(new ChunkPosDimension(dim, fieldX, fieldZ), fluid, yield, percent);
    }

    public UndergroundFluidPosition(ChunkPosDimension pos, String fluid, int yield, double percent) {
        this.pos = pos;
        this.fluid = fluid;
        this.yield = yield;
        this.percent = percent;
        Fluid f = FluidRegistry.getFluid((String)fluid);
        this.name = f.getLocalizedName(null);
        this.color = DrawUtils.getFluidColor(f);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = this.pos.writeToNBT();
        NBTTagCompound info = new NBTTagCompound();
        info.func_74778_a("fluid", this.fluid);
        info.func_74768_a("yield", this.yield);
        info.func_74780_a("percent", this.percent);
        result.func_74782_a("info", (NBTBase)info);
        return result;
    }

    public static UndergroundFluidPosition fromNBT(NBTTagCompound nbt) {
        NBTTagCompound info = nbt.func_74775_l("info");
        return new UndergroundFluidPosition(ChunkPosDimension.readFromNBT((NBTTagCompound)nbt), info.func_74779_i("fluid"), info.func_74762_e("yield"), info.func_74769_h("percent"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UndergroundFluidPosition that = (UndergroundFluidPosition)o;
        return this.yield == that.yield && Double.compare(that.percent, this.percent) == 0 && Objects.equals(this.pos, that.pos) && Objects.equals(this.fluid, that.fluid);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.fluid, this.yield, this.percent);
    }
}

