/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import hellfall.visualores.database.gregtech.ore.DimensionCache;
import hellfall.visualores.database.gregtech.ore.OreVeinPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class WorldCache {
    protected final Map<Integer, DimensionCache> cache = new HashMap<Integer, DimensionCache>();

    public boolean addVein(int dim, int x, int z, int gridX, int gridZ, String name) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, new DimensionCache());
        }
        return this.cache.get(dim).addVein(x, z, gridX, gridZ, name);
    }

    public List<OreVeinPosition> getNearbyVeins(int dim, BlockPos pos, int blockRadius) {
        if (this.cache.containsKey(dim)) {
            return this.cache.get(dim).getNearbyVeins(pos, blockRadius);
        }
        return new ArrayList<OreVeinPosition>();
    }

    public List<OreVeinPosition> getVeinsInArea(int dim, int[] bounds) {
        if (this.cache.containsKey(dim)) {
            return this.cache.get(dim).getVeinsInBounds(new BlockPos(bounds[0], 0, bounds[1]), new BlockPos(bounds[0] + bounds[2], 0, bounds[1] + bounds[3]));
        }
        return new ArrayList<OreVeinPosition>();
    }

    public void clear() {
        this.cache.clear();
    }
}

