/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.thaumcraft;

import hellfall.visualores.database.IClientCachePerDimOnly;
import hellfall.visualores.database.thaumcraft.AuraFluxPosition;
import hellfall.visualores.database.thaumcraft.TCDimensionCache;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class TCClientCache
implements IClientCachePerDimOnly {
    public static final TCClientCache instance = new TCClientCache();
    private final Int2ObjectMap<TCDimensionCache> cache = new Int2ObjectArrayMap();

    public void addChunk(short base, float aura, float flux) {
        int dim = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new TCDimensionCache());
        }
        ((TCDimensionCache)this.cache.get(dim)).addChunk(base, aura, flux);
    }

    public List<AuraFluxPosition> getVeinsInArea(int dim, int[] bounds) {
        if (this.cache.containsKey(dim)) {
            return ((TCDimensionCache)this.cache.get(dim)).getVeinsInArea(new ChunkPos(bounds[0] >> 4, bounds[1] >> 4), new ChunkPos(bounds[0] + bounds[2] >> 4, bounds[1] + bounds[3] >> 4));
        }
        return new ArrayList<AuraFluxPosition>();
    }

    @Override
    public void setupCacheFiles() {
        this.addDimFiles("aura_");
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Collection<Integer> getExistingDimensions(String prefix) {
        return this.cache.keySet();
    }

    @Override
    public NBTTagCompound saveDimFile(String prefix, int dim) {
        if (this.cache.containsKey(dim)) {
            return ((TCDimensionCache)this.cache.get(dim)).toNBT();
        }
        return null;
    }

    @Override
    public void readDimFile(String prefix, int dim, NBTTagCompound data) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new TCDimensionCache());
        }
        ((TCDimensionCache)this.cache.get(dim)).fromNBT(data);
    }
}

