/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.gtmodule;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.modules.GregTechModule;
import gregtech.api.network.IPacket;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.BlockSurfaceRock;
import gregtech.modules.BaseGregTechModule;
import hellfall.visualores.VOConfig;
import hellfall.visualores.VisualOres;
import hellfall.visualores.database.ClientCacheManager;
import hellfall.visualores.database.gregtech.GTClientCache;
import hellfall.visualores.database.gregtech.ore.OreVeinInfo;
import hellfall.visualores.database.gregtech.ore.ServerCache;
import hellfall.visualores.map.layers.Layers;
import hellfall.visualores.map.layers.gregtech.OreRenderLayer;
import hellfall.visualores.map.layers.gregtech.UndergroundFluidRenderLayer;
import hellfall.visualores.network.gregtech.FluidSaveVersionPacket;
import hellfall.visualores.network.gregtech.OreProspectToClientPacket;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@GregTechModule(moduleID="visualores", containerID="visualores", name="VisualOres module", coreModule=true, description="VisualOres GregTech Integration. Disabling this will disable all GT integration in VisualOres.")
public class VisualOresModule
extends BaseGregTechModule {
    @Nonnull
    public List<Class<?>> getEventBusSubscribers() {
        return Collections.singletonList(VisualOresModule.class);
    }

    @Nonnull
    public Logger getLogger() {
        return VisualOres.LOGGER;
    }

    public void registerPackets() {
        GregTechAPI.networkHandler.registerPacket(OreProspectToClientPacket.class);
        GregTechAPI.networkHandler.registerPacket(FluidSaveVersionPacket.class);
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (GTValues.isClientSide()) {
            Layers.registerLayer(OreRenderLayer.class, "oreveins");
            Layers.registerLayer(UndergroundFluidRenderLayer.class, "undergroundfluid");
            ClientCacheManager.registerClientCache(GTClientCache.instance, "gregtech");
        }
    }

    public void serverStopped(FMLServerStoppedEvent event) {
        ServerCache.instance.clear();
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            ServerCache.instance.maybeInitWorld(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            ServerCache.instance.invalidateWorld(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity;
        if (!event.getWorld().field_72995_K && (entity = event.getEntity()) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            GregTechAPI.networkHandler.sendTo((IPacket)new FluidSaveVersionPacket(BedrockFluidVeinHandler.saveDataVersion), player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer entityPlayer;
        if (event.getSide() == Side.SERVER && (entityPlayer = event.getEntityPlayer()) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() instanceof BlockOre) {
                Material oreMaterial = OreVeinInfo.getMaterial(state);
                if (!oreMaterial.equals(Materials.NULL)) {
                    ServerCache.instance.prospectByOreMaterial(event.getWorld().field_73011_w.getDimension(), oreMaterial, event.getPos(), player, VOConfig.server.gregtech.oreBlockProspectRange);
                }
            } else {
                Block block = state.func_177230_c();
                if (block instanceof BlockSurfaceRock) {
                    BlockSurfaceRock block2 = (BlockSurfaceRock)block;
                    ServerCache.instance.prospectSurfaceRockMaterial(event.getWorld().field_73011_w.getDimension(), (Material)state.func_177229_b((IProperty)block2.getVariantProperty()), event.getPos(), player);
                }
            }
        }
    }
}

