/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.lib.io.xol.enklume.nbt;

import hellfall.visualores.lib.io.xol.enklume.nbt.NBTCompound;
import hellfall.visualores.lib.io.xol.enklume.nbt.NBTNamed;
import hellfall.visualores.lib.io.xol.enklume.nbt.NBTag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NBTList
extends NBTNamed {
    int type;
    int number;
    public List<NBTNamed> elements = new ArrayList<NBTNamed>();

    @Override
    void feed(ByteBuffer is) throws IOException {
        super.feed(is);
        this.type = is.get();
        this.number = is.getInt();
        if (this.type > 0) {
            for (int i = 0; i < this.number; ++i) {
                NBTag tag = NBTList.createNamedFromList(this.type, i);
                tag.feed(is);
                this.elements.add((NBTNamed)tag);
            }
        }
    }

    public NBTNamed getTag(String path) {
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.equals("")) {
            return this;
        }
        String[] s = path.split("\\.");
        String looking = s[0];
        int index = Integer.parseInt(looking);
        if (index < this.elements.size()) {
            NBTNamed found = this.elements.get(index);
            if (s.length > 1) {
                String deeper = path.substring(looking.length() + 1);
                if (found instanceof NBTCompound) {
                    return ((NBTCompound)found).getTag(deeper);
                }
                if (found instanceof NBTList) {
                    return ((NBTList)found).getTag(deeper);
                }
                System.out.println("error: Can't traverse tag " + found + "; not a Compound, nor a List tag.");
            } else {
                return found;
            }
        }
        return null;
    }
}

