/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map;

import codechicken.lib.gui.GuiDraw;
import gregtech.api.fluids.GTFluid;
import gregtech.api.util.GTUtility;
import hellfall.visualores.VOConfig;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;

public class DrawUtils {
    public static final Object2IntMap<String> colorOverrides = new Object2IntOpenHashMap();

    public static void drawSimpleTooltip(List<String> text, double x, double y, int screenW, int screenH, int fontColor, int bgColor) {
        if (text.isEmpty()) {
            return;
        }
        int boxHeight = text.size() * (GuiDraw.fontRenderer.field_78288_b + 2) + 6;
        if (boxHeight > screenH) {
            int maxLines = (screenH - 6) / (GuiDraw.fontRenderer.field_78288_b + 2);
            int oldsize = text.size();
            text = text.subList(0, maxLines - 1);
            text.add(I18n.func_135052_a((String)"visualores.tooltipoverflow", (Object[])new Object[]{oldsize - maxLines + 1}));
            boxHeight = text.size() * (GuiDraw.fontRenderer.field_78288_b + 2) + 6;
        }
        int maxTextWidth = 0;
        for (String str : text) {
            int strWidth = GuiDraw.fontRenderer.func_78256_a(str);
            if (strWidth <= maxTextWidth) continue;
            maxTextWidth = strWidth;
        }
        int boxWidth = maxTextWidth + 6;
        if (x + (double)boxWidth > (double)screenW) {
            x = x - (double)boxWidth < 0.0 ? (double)Math.max(0, screenW - boxWidth) : (x -= (double)boxWidth);
        }
        if (y + (double)boxHeight > (double)screenH) {
            y = y - (double)boxHeight < 0.0 ? (double)Math.max(0, screenH - boxHeight) : (y -= (double)boxHeight);
        }
        double dx = x - (double)((int)x);
        double dy = y - (double)((int)y);
        GlStateManager.func_179094_E();
        GuiDraw.drawGradientRect((int)((int)x), (int)((int)y), (int)boxWidth, (int)boxHeight, (int)bgColor, (int)bgColor);
        GlStateManager.func_179137_b((double)dx, (double)dy, (double)0.0);
        for (int i = 0; i < text.size(); ++i) {
            GuiDraw.drawString((String)text.get(i), (int)((int)x + 3), (int)((int)y + 3 + i * (GuiDraw.fontRenderer.field_78288_b + 2)), (int)fontColor, (boolean)false);
        }
        GlStateManager.func_179121_F();
    }

    public static void drawOverlayBox(int left, int top, int right, int bottom, int sideColor, int middleColor) {
        GuiDraw.drawGradientRectDirect((int)left, (int)top, (int)(right - 1), (int)(top + 1), (int)sideColor, (int)sideColor);
        GuiDraw.drawGradientRectDirect((int)(right - 1), (int)top, (int)right, (int)(bottom - 1), (int)sideColor, (int)sideColor);
        GuiDraw.drawGradientRectDirect((int)left, (int)(top + 1), (int)(left + 1), (int)bottom, (int)sideColor, (int)sideColor);
        GuiDraw.drawGradientRectDirect((int)(left + 1), (int)(bottom - 1), (int)right, (int)bottom, (int)sideColor, (int)sideColor);
        GuiDraw.drawGradientRectDirect((int)(left + 1), (int)(top + 1), (int)(right - 1), (int)(bottom - 1), (int)middleColor, (int)middleColor);
    }

    public static void drawOverlayBox(int chunkX, int chunkZ, int sideColor, int middleColor) {
        DrawUtils.drawOverlayBox(chunkX * 16, chunkZ * 16, (chunkX + 1) * 16, (chunkZ + 1) * 16, sideColor, middleColor);
    }

    public static float[] floats(int argb) {
        return new float[]{(float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >> 24 & 0xFF) / 255.0f};
    }

    public static BlockPos getMouseBlockPos(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        int mouseBlockX = (int)Math.floor((mouseX - (double)Minecraft.func_71410_x().field_71443_c / 2.0) / scale + cameraX);
        int mouseBlockZ = (int)Math.floor((mouseY - (double)Minecraft.func_71410_x().field_71440_d / 2.0) / scale + cameraZ);
        return new BlockPos(mouseBlockX, 0, mouseBlockZ);
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        int color = fluid.getColor();
        if (colorOverrides.containsKey((Object)fluid.getName())) {
            color = (Integer)colorOverrides.get((Object)fluid.getName()) | 0xFF000000;
        } else if (color == -1 && Loader.isModLoaded((String)"gregtech")) {
            color = DrawUtils.gtMaterialColor(fluid);
        }
        return color;
    }

    private static int gtMaterialColor(Fluid fluid) {
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid materialFluid = (GTFluid.GTMaterialFluid)fluid;
            return GTUtility.convertRGBtoOpaqueRGBA_MC((int)materialFluid.getMaterial().getMaterialRGB());
        }
        return fluid.getColor();
    }

    public static void initColorOverrides() {
        for (String entry : VOConfig.client.fluidColorOverrides) {
            String[] parts = entry.split("=");
            colorOverrides.put((Object)parts[0], (Object)Integer.decode(parts[1]));
        }
    }
}

