/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map;

import hellfall.visualores.map.IWaypointHandler;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class WaypointManager {
    public static int currentDimension;
    private static final Set<IWaypointHandler> handlers;
    private static final Object2ObjectMap<String, WaypointKey> waypoints;

    public static void updateDimension(int dim) {
        currentDimension = dim;
    }

    public static void setWaypoint(String key, String name, int color, Integer dim, int x, int y, int z) {
        if (dim == null) {
            dim = currentDimension;
        }
        for (IWaypointHandler handler : handlers) {
            handler.setWaypoint(key, name, color, dim, x, y, z);
        }
        waypoints.put((Object)key, (Object)new WaypointKey(dim, x, y, z));
    }

    public static void removeWaypoint(String key) {
        for (IWaypointHandler handler : handlers) {
            handler.removeWaypoint(key);
        }
        waypoints.remove((Object)key);
    }

    public static boolean toggleWaypoint(String key, String name, int color, Integer dim, int x, int y, int z) {
        if (dim == null) {
            dim = currentDimension;
        }
        if (new WaypointKey(dim, x, y, z).equals(waypoints.get((Object)key))) {
            WaypointManager.removeWaypoint(key);
            return false;
        }
        WaypointManager.setWaypoint(key, name, color, dim, x, y, z);
        return true;
    }

    public static void registerWaypointHandler(IWaypointHandler handler) {
        handlers.add(handler);
    }

    static {
        handlers = new HashSet<IWaypointHandler>();
        waypoints = new Object2ObjectArrayMap();
    }

    private static class WaypointKey {
        int dim;
        int x;
        int y;
        int z;

        public WaypointKey(int dim, int x, int y, int z) {
            this.dim = dim;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WaypointKey that = (WaypointKey)o;
            return this.dim == that.dim && this.x == that.x && this.y == that.y && this.z == that.z;
        }

        public int hashCode() {
            return Objects.hash(this.dim, this.x, this.y, this.z);
        }
    }
}

