/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers;

import hellfall.visualores.VOConfig;
import hellfall.visualores.map.ButtonState;
import hellfall.visualores.map.layers.RenderLayer;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Layers {
    private static final Map<Class<? extends RenderLayer>, String> layerClasses = new HashMap<Class<? extends RenderLayer>, String>();
    private static List<Class<? extends RenderLayer>> sortedLayers;

    public static void registerLayer(Class<? extends RenderLayer> clazz, String key) {
        if (Arrays.asList(VOConfig.client.ignoreLayers).contains(key)) {
            return;
        }
        layerClasses.put(clazz, key);
        ButtonState.Button.makeButton(key);
    }

    public static void addLayersTo(List<RenderLayer> layers) {
        if (sortedLayers == null) {
            sortedLayers = layerClasses.keySet().stream().sorted(Comparator.comparingInt(l -> Arrays.asList(VOConfig.client.buttonOrder).indexOf(layerClasses.get(l)))).collect(Collectors.toList());
        }
        for (Class<? extends RenderLayer> layer : sortedLayers) {
            try {
                layers.add(layer.getConstructor(String.class).newInstance(layerClasses.get(layer)));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Collection<String> allKeys() {
        return layerClasses.values();
    }
}

