/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers;

import hellfall.visualores.map.ButtonState;
import hellfall.visualores.map.WaypointManager;
import java.util.List;

public abstract class RenderLayer {
    protected final String key;

    public RenderLayer(String key) {
        this.key = key;
    }

    public boolean isEnabled() {
        return ButtonState.isEnabled(this.key);
    }

    public abstract void render(double var1, double var3, double var5);

    public abstract void updateVisibleArea(int var1, int[] var2);

    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
    }

    public List<String> getTooltip() {
        return null;
    }

    public boolean onActionKey() {
        return false;
    }

    public boolean onClick() {
        return false;
    }

    public boolean onDoubleClick() {
        return false;
    }

    protected final boolean toggleWaypoint(String name, int color, Integer dim, int x, int y, int z) {
        return WaypointManager.toggleWaypoint(this.key, name, color, dim, x, y, z);
    }
}

