/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers.gregtech;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.texture.TextureUtils;
import hellfall.visualores.VOConfig;
import hellfall.visualores.database.gregtech.GTClientCache;
import hellfall.visualores.database.gregtech.ore.OreVeinPosition;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class OreRenderLayer
extends RenderLayer {
    protected static final ResourceLocation STONE = new ResourceLocation("textures/blocks/stone.png");
    protected static final ResourceLocation DEPLETED = new ResourceLocation("visualores", "textures/depleted.png");
    protected List<OreVeinPosition> visibleVeins = new ArrayList<OreVeinPosition>();
    protected List<OreVeinPosition> hoveredVeins = new ArrayList<OreVeinPosition>();
    protected static OreVeinPosition waypointVein;

    public OreRenderLayer(String key) {
        super(key);
    }

    @Override
    public void render(double cameraX, double cameraZ, double scale) {
        double clampedScale = Math.max(scale, VOConfig.client.gregtech.oreScaleStop);
        int iconSize = VOConfig.client.gregtech.oreIconSize;
        for (OreVeinPosition vein : this.visibleVeins) {
            int thickness;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)vein.x + 0.5), (double)((double)vein.z + 0.5), (double)0.0);
            GlStateManager.func_179139_a((double)(1.0 / clampedScale), (double)(1.0 / clampedScale), (double)1.0);
            float[] colors = DrawUtils.floats(vein.veinInfo.color);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (vein.veinInfo.texture != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(STONE);
                Gui.func_146110_a((int)(-iconSize / 2), (int)(-iconSize / 2), (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (float)iconSize, (float)iconSize);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(vein.veinInfo.texture);
                GlStateManager.func_179131_c((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
                Gui.func_146110_a((int)(-iconSize / 2), (int)(-iconSize / 2), (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (float)iconSize, (float)iconSize);
            } else if (vein.veinInfo.tas != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                GuiDraw.gui.func_175175_a(-iconSize / 2, -iconSize / 2, vein.veinInfo.tas, iconSize, iconSize);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                GuiDraw.gui.func_175175_a(-iconSize / 2, -iconSize / 2, TextureUtils.getMissingSprite(), iconSize, iconSize);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int borderColor = VOConfig.client.gregtech.getBorderColor(vein.veinInfo.color | 0xFF000000);
            if ((borderColor & 0xFF000000) != 0) {
                thickness = iconSize / 16;
                GuiDraw.drawRect((int)(-iconSize / 2), (int)(-iconSize / 2), (int)iconSize, (int)thickness, (int)borderColor);
                GuiDraw.drawRect((int)(-iconSize / 2), (int)(iconSize / 2 - thickness), (int)iconSize, (int)thickness, (int)borderColor);
                GuiDraw.drawRect((int)(-iconSize / 2), (int)(-iconSize / 2), (int)thickness, (int)iconSize, (int)borderColor);
                GuiDraw.drawRect((int)(iconSize / 2 - thickness), (int)(-iconSize / 2), (int)thickness, (int)iconSize, (int)borderColor);
            }
            if (vein.depleted) {
                GuiDraw.drawRect((int)(-iconSize / 2), (int)(-iconSize / 2), (int)iconSize, (int)iconSize, (int)-1778384896);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DEPLETED);
                Gui.func_146110_a((int)(-iconSize / 2), (int)(-iconSize / 2), (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (float)iconSize, (float)iconSize);
            }
            if (vein == waypointVein) {
                thickness = iconSize / 8;
                int color = -10496;
                GuiDraw.drawRect((int)(-thickness - iconSize / 2), (int)(-thickness - iconSize / 2), (int)(thickness + iconSize), (int)thickness, (int)color);
                GuiDraw.drawRect((int)(iconSize / 2), (int)(-thickness - iconSize / 2), (int)thickness, (int)(thickness + iconSize), (int)color);
                GuiDraw.drawRect((int)(-thickness - iconSize / 2), (int)(-iconSize / 2), (int)thickness, (int)(thickness + iconSize), (int)color);
                GuiDraw.drawRect((int)(-iconSize / 2), (int)(iconSize / 2), (int)(thickness + iconSize), (int)thickness, (int)color);
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void updateVisibleArea(int dimensionID, int[] visibleBounds) {
        this.visibleVeins = GTClientCache.instance.getVeinsInArea(dimensionID, visibleBounds);
    }

    @Override
    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        this.hoveredVeins.clear();
        double clampedScale = Math.max(scale, VOConfig.client.gregtech.oreScaleStop);
        double iconRadius = (double)VOConfig.client.gregtech.oreIconSize / 2.0 * (scale / clampedScale);
        Minecraft mc = Minecraft.func_71410_x();
        mouseX -= (double)mc.field_71443_c / 2.0;
        mouseY -= (double)mc.field_71440_d / 2.0;
        for (OreVeinPosition vein : this.visibleVeins) {
            double scaledVeinX = ((double)vein.x + 0.5 - cameraX) * scale;
            double scaledVeinZ = ((double)vein.z + 0.5 - cameraZ) * scale;
            if (!(mouseX > scaledVeinX - iconRadius) || !(mouseX < scaledVeinX + iconRadius) || !(mouseY > scaledVeinZ - iconRadius) || !(mouseY < scaledVeinZ + iconRadius)) continue;
            this.hoveredVeins.add(vein);
        }
        Collections.reverse(this.hoveredVeins);
    }

    @Override
    public List<String> getTooltip() {
        List<String> tooltip = new ArrayList<String>();
        if (VOConfig.client.stackTooltips) {
            for (OreVeinPosition vein : this.hoveredVeins) {
                tooltip.addAll(vein.getTooltipStrings());
            }
        } else if (!this.hoveredVeins.isEmpty()) {
            tooltip = this.hoveredVeins.get(0).getTooltipStrings();
        }
        return tooltip;
    }

    @Override
    public boolean onActionKey() {
        if (this.hoveredVeins.isEmpty()) {
            return false;
        }
        this.hoveredVeins.get((int)0).depleted = !this.hoveredVeins.get((int)0).depleted;
        return true;
    }

    @Override
    public boolean onDoubleClick() {
        if (this.hoveredVeins.isEmpty()) {
            return false;
        }
        OreVeinPosition vein = this.hoveredVeins.get(0);
        waypointVein = this.toggleWaypoint(vein.getTooltipStrings().get(0), vein.veinInfo.color, null, vein.x, 64, vein.z) ? vein : null;
        return true;
    }
}

