/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers.gregtech;

import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import hellfall.visualores.database.gregtech.GTClientCache;
import hellfall.visualores.database.gregtech.fluid.UndergroundFluidPosition;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;

public class UndergroundFluidRenderLayer
extends RenderLayer {
    protected List<UndergroundFluidPosition> visibleFluids = new ArrayList<UndergroundFluidPosition>();
    protected UndergroundFluidPosition hovered;

    public UndergroundFluidRenderLayer(String key) {
        super(key);
    }

    @Override
    public void render(double cameraX, double cameraZ, double scale) {
        for (UndergroundFluidPosition fluidPos : this.visibleFluids) {
            int sideColor = (fluidPos.color & 0xFFFFFF) + -587202560;
            int midColor = (fluidPos.color & 0xFFFFFF) + 0x77000000;
            int t = this.adjustForBadCoords(fluidPos.pos.field_77275_b * 8) * 16;
            int b = this.adjustForBadCoords((fluidPos.pos.field_77275_b + 1) * 8) * 16;
            int l = this.adjustForBadCoords(fluidPos.pos.field_77276_a * 8) * 16;
            int r = this.adjustForBadCoords((fluidPos.pos.field_77276_a + 1) * 8) * 16;
            DrawUtils.drawOverlayBox(l, t, r, b, sideColor, midColor);
        }
    }

    @Override
    public void updateVisibleArea(int dimensionID, int[] visibleBounds) {
        this.visibleFluids = GTClientCache.instance.getFluidsInArea(dimensionID, visibleBounds);
    }

    @Override
    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        BlockPos mouseBlock = DrawUtils.getMouseBlockPos(mouseX, mouseY, cameraX, cameraZ, scale);
        int mouseFieldX = BedrockFluidVeinHandler.getVeinCoord((int)(mouseBlock.func_177958_n() >> 4));
        int mouseFieldZ = BedrockFluidVeinHandler.getVeinCoord((int)(mouseBlock.func_177952_p() >> 4));
        this.hovered = null;
        for (UndergroundFluidPosition fluidPos : this.visibleFluids) {
            if (mouseFieldX != fluidPos.pos.field_77276_a || mouseFieldZ != fluidPos.pos.field_77275_b) continue;
            this.hovered = fluidPos;
            break;
        }
    }

    @Override
    public List<String> getTooltip() {
        if (this.hovered == null) {
            return null;
        }
        return Collections.singletonList(I18n.func_135052_a((String)"terminal.prospector.fluid.info", (Object[])new Object[]{this.hovered.name, this.hovered.yield, this.hovered.percent}));
    }

    private int adjustForBadCoords(int chunkCoord) {
        if (BedrockFluidVeinHandler.saveDataVersion < 2 && chunkCoord <= 0) {
            return chunkCoord - 7;
        }
        return chunkCoord;
    }
}

