/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers.thaumcraft;

import hellfall.visualores.database.thaumcraft.AuraFluxPosition;
import hellfall.visualores.database.thaumcraft.TCClientCache;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.ChunkPos;

public class AuraFluxRenderLayer
extends RenderLayer {
    private List<AuraFluxPosition> visibleChunks = new ArrayList<AuraFluxPosition>();
    private AuraFluxPosition hoveredChunk;

    public AuraFluxRenderLayer(String key) {
        super(key);
    }

    @Override
    public void render(double cameraX, double cameraZ, double scale) {
        for (AuraFluxPosition chunk : this.visibleChunks) {
            DrawUtils.drawOverlayBox(chunk.x, chunk.z, chunk.color, chunk.midColor);
        }
    }

    @Override
    public void updateVisibleArea(int dimensionID, int[] visibleBounds) {
        this.visibleChunks = TCClientCache.instance.getVeinsInArea(dimensionID, visibleBounds);
    }

    @Override
    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        ChunkPos mousePos = new ChunkPos(DrawUtils.getMouseBlockPos(mouseX, mouseY, cameraX, cameraZ, scale));
        this.hoveredChunk = null;
        for (AuraFluxPosition chunk : this.visibleChunks) {
            if (chunk.x != mousePos.field_77276_a || chunk.z != mousePos.field_77275_b) continue;
            this.hoveredChunk = chunk;
            break;
        }
    }

    @Override
    public List<String> getTooltip() {
        if (this.hoveredChunk != null) {
            return this.hoveredChunk.tooltips;
        }
        return null;
    }
}

