/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.mixins.gregtech;

import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.generator.CachedGridEntry;
import gregtech.api.worldgen.generator.GTWorldGenCapability;
import hellfall.visualores.database.gregtech.ore.ServerCache;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CachedGridEntry.class}, remap=false)
public abstract class CachedGridEntryMixin {
    @Shadow
    private int veinCenterX;
    @Shadow
    private int veinCenterY;
    @Shadow
    private int veinCenterZ;
    @Shadow
    @Final
    private int gridX;
    @Shadow
    @Final
    private int gridZ;
    @Unique
    private int dimid;

    @Inject(method={"searchMasterOrNull"}, at={@At(value="HEAD")})
    private void visualores$injectInit(World world, CallbackInfoReturnable<GTWorldGenCapability> cir) {
        this.dimid = world.field_73011_w.getDimension();
    }

    @Inject(method={"doGenerateVein"}, at={@At(value="INVOKE", target="Lgregtech/api/worldgen/shape/ShapeGenerator;generate(Ljava/util/Random;Lgregtech/api/worldgen/shape/IBlockGeneratorAccess;)V")})
    private void visualores$injectGenerateVein(OreDepositDefinition definition, CallbackInfo ci) {
        if (definition.isVein()) {
            ServerCache.instance.addVein(this.dimid, this.veinCenterX, this.veinCenterZ, this.gridX, this.gridZ, definition.getDepositName());
        }
    }
}

