/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.mixins.journeymap;

import hellfall.visualores.VOConfig;
import hellfall.visualores.map.GenericMapRenderer;
import hellfall.visualores.mixins.journeymap.DisplayVarsAccessor;
import journeymap.client.model.MapState;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.MiniMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MiniMap.class}, remap=false)
public abstract class MiniMapMixin {
    @Shadow
    private DisplayVars dv;
    @Shadow
    private MiniMapProperties miniMapProperties;
    @Shadow
    @Final
    private static MapState state;
    @Shadow
    @Final
    private static GridRenderer gridRenderer;
    @Shadow
    @Final
    private Minecraft mc;
    @Unique
    private GenericMapRenderer renderer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void visualores$injectInit(MiniMapProperties miniMapProperties, CallbackInfo ci) {
        this.renderer = new GenericMapRenderer();
    }

    @Inject(method={"drawOnMapWaypoints"}, at={@At(value="HEAD")})
    private void visualores$injectDrawMinimap(double rotation, CallbackInfo ci) {
        if (VOConfig.client.enableMinimapRendering) {
            double scale = Math.pow(2.0, this.miniMapProperties.zoomLevel.get().intValue());
            double rw = (double)((DisplayVarsAccessor)this.dv).getMinimapWidth() / scale;
            double rh = (double)((DisplayVarsAccessor)this.dv).getMinimapHeight() / scale;
            this.renderer.updateVisibleArea(state.getDimension(), (int)(gridRenderer.getCenterBlockX() - rw / 2.0), (int)(gridRenderer.getCenterBlockZ() - rh / 2.0), (int)rw, (int)rh);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)this.mc.field_71443_c / 2.0), (double)((double)this.mc.field_71440_d / 2.0), (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
            GlStateManager.func_179137_b((double)(-gridRenderer.getCenterBlockX()), (double)(-gridRenderer.getCenterBlockZ()), (double)0.0);
            this.renderer.render(gridRenderer.getCenterBlockX(), gridRenderer.getCenterBlockZ(), scale);
            GlStateManager.func_179121_F();
        }
    }
}

