/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.proxy;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import hellfall.visualores.KeyBindings;
import hellfall.visualores.VisualOres;
import hellfall.visualores.commands.VOClientCommand;
import hellfall.visualores.database.ClientCacheManager;
import hellfall.visualores.database.astralsorcery.ASClientCache;
import hellfall.visualores.database.immersiveengineering.IEClientCache;
import hellfall.visualores.database.thaumcraft.TCClientCache;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.WaypointManager;
import hellfall.visualores.map.journeymap.JourneymapWaypointHandler;
import hellfall.visualores.map.layers.Layers;
import hellfall.visualores.map.layers.astralsorcery.NeromanticRenderLayer;
import hellfall.visualores.map.layers.astralsorcery.StarfieldRenderLayer;
import hellfall.visualores.map.layers.immersiveengineering.ExcavatorRenderLayer;
import hellfall.visualores.map.layers.thaumcraft.AuraFluxRenderLayer;
import hellfall.visualores.map.xaero.XaeroWaypointHandler;
import hellfall.visualores.network.CCLClientPacketHandler;
import hellfall.visualores.proxy.VOCommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class VOClientProxy
extends VOCommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (Loader.isModLoaded((String)"xaerominimap")) {
            WaypointManager.registerWaypointHandler(new XaeroWaypointHandler());
        }
        if (Loader.isModLoaded((String)"journeymap")) {
            WaypointManager.registerWaypointHandler(new JourneymapWaypointHandler());
        }
        DrawUtils.initColorOverrides();
        PacketCustom.assignHandler((Object)"visualores", (ICustomPacketHandler)new CCLClientPacketHandler());
        if (Loader.isModLoaded((String)"astralsorcery")) {
            Layers.registerLayer(StarfieldRenderLayer.class, "starlight");
            Layers.registerLayer(NeromanticRenderLayer.class, "neromantic");
            ClientCacheManager.registerClientCache(ASClientCache.instance, "astral");
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            Layers.registerLayer(AuraFluxRenderLayer.class, "aura_flux");
            ClientCacheManager.registerClientCache(TCClientCache.instance, "thaumcraft");
        }
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            Layers.registerLayer(ExcavatorRenderLayer.class, "excavator");
            ClientCacheManager.registerClientCache(IEClientCache.instance, "immeng");
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        KeyBindings.action = new KeyBinding("visualores.key.action", (IKeyConflictContext)KeyConflictContext.GUI, 211, "visualores.keycategory");
        ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.action);
        for (String layer : Layers.allKeys()) {
            KeyBinding binding = new KeyBinding("visualores.button." + layer, (IKeyConflictContext)KeyConflictContext.IN_GAME, 0, "visualores.keycategory");
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
            KeyBindings.layerToggles.put(binding, layer);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ClientCommandHandler.instance.func_71560_a((ICommand)new VOClientCommand());
    }

    @Override
    public void serverStopped(FMLServerStoppedEvent event) {
        super.serverStopped(event);
        ClientCacheManager.clearCaches();
    }

    @Override
    public void worldLoad(WorldEvent.Load event) {
        super.worldLoad(event);
        if (event.getWorld().field_72995_K) {
            WaypointManager.updateDimension(event.getWorld().field_73011_w.getDimension());
        }
    }

    @Override
    public void worldUnload(WorldEvent.Unload event) {
        super.worldUnload(event);
        if (event.getWorld().field_72995_K) {
            ClientCacheManager.saveCaches();
        }
    }

    @Override
    public void worldSave(WorldEvent.Save event) {
        super.worldSave(event);
        if (event.getWorld().field_72995_K) {
            ClientCacheManager.saveCaches();
        }
    }

    @Override
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        super.entityJoinWorld(event);
        if (VisualOres.isClientOnlyMode() && event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerSP) {
            String cacheName = "unknown";
            if (Minecraft.func_71410_x().func_147104_D() != null) {
                cacheName = Minecraft.func_71410_x().func_147104_D().field_78845_b;
            }
            ClientCacheManager.init("Server-" + cacheName + "-client-only");
        }
    }

    @Override
    public void syncConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        super.syncConfig(event);
        if (event.getModID().equals("visualores")) {
            ConfigManager.sync((String)"visualores", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Override
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        super.onKeyPress(event);
        KeyBindings.toggleLayers();
    }

    @Override
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        super.onClientDisconnect(event);
        ClientCacheManager.allowReinit();
    }
}

